//
//  QGCreditApplySubmitCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

//《享花卡消费贷款服务协议》
#define ConsumerLoanAgreement @"https://h5.q-gp.com/user/contract/center?token={token}&h=0&domainName=talos&contractTemplateId=268"
//《个人信息查询及使用综合授权书》
#define AuthorizationAgreement @"https://h5.q-gp.com/user/contract/center?token={token}&h=0&domainName=talos&contractTemplateId=298"
//《客户非学生承诺函》
#define PromiseAgreement @"https://h5.q-gp.com/user/contract/center?token={token}&h=0&domainName=talos&contractTemplateId=328"

#import "QGCreditApplySubmitCell.h"
#import "ZHHitLabel.h"
#import "ZHAttributedLabelTool.h"
#import "QGBasicUITool.h"

@interface QGCreditApplySubmitCell ()

/// 协议承载视图
@property (nonatomic, strong) ZHHitLabel * protocolLabel;

@end

@implementation QGCreditApplySubmitCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        
        /// 协议承载视图
        self.protocolLabel = [[ZHHitLabel alloc] init];
        self.protocolLabel.numberOfLines = 0;
        [self.contentView addSubview:self.protocolLabel];
        [self.protocolLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.inset(13);
        }];
        
        //点击事件
        @weakify(self);
        self.protocolLabel.clickBlock = ^(ZHRichHelpModel *model) {
            @strongify(self);
            if ([model.valueStr containsString:@"享花卡消费贷款服务协议"]) {
                if (self.agreementClick) {
                    self.agreementClick(ConsumerLoanAgreement);
                }
            }
            else if ([model.valueStr containsString:@"个人信息查询及使用综合授权书"])
            {
                if (self.agreementClick) {
                    self.agreementClick(AuthorizationAgreement);
                }
            }
            else if ([model.valueStr containsString:@"客户非学生承诺函"])
            {
                if (self.agreementClick) {
                    self.agreementClick(PromiseAgreement);
                }
            }
            else if ([model.valueStr containsString:@"我已阅读"])
            {
                if (self.agressClick) {
                    self.agressClick();
                }
                self.isAgree = !self.isAgree;
            }
        };
        
        //提交按钮
        self.submitButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.contentView title:@"立即申请" textFont:[UIFont qg_regularFontOfSize:17]];
        [self.submitButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.bottom.inset(10);
            make.height.mas_equalTo(40);
        }];
        
        
    }
    return self;
}

- (void)setIsAgree:(BOOL)isAgree
{
    _isAgree = isAgree;
    self.protocolLabel.attributedText = [[QGCreditApplySubmitCell protocolToolIsSelect:isAgree] getResultString];
}


+ (ZHAttributedLabelTool *)protocolToolIsSelect:(BOOL)select
{
    NSString * protocolString = @" 我已阅读并同意《享花卡消费贷款服务协议》《个人信息查询及使用综合授权书》《客户非学生承诺函》";
    ZHAttributedLabelTool * protocolTool = [[ZHAttributedLabelTool alloc] initWithText:protocolString font:[UIFont qg_lightFontOfSize:12] color:[UIColor textColor6666]];
    
    //添加图片
    [protocolTool addAttachmentWithImageName:select == YES ? @"selected" : @"notSelect" index:0 size:CGRectMake(0, -2, 12, 12)];
    [protocolTool addRichHelpWithType:ZHRichHelpTypeClick range:NSMakeRange(0, 8) color:[UIColor textColor6666]];
    
    //消费协议
    NSRange consumerLoanRange = [[protocolTool getResultString].string rangeOfString:@"《享花卡消费贷款服务协议》"];
    [protocolTool addRichHelpWithType:ZHRichHelpTypeClick range:consumerLoanRange color:[UIColor mainThemeColor]];
    
    //授权协议
    NSRange authorizationRange = [[protocolTool getResultString].string rangeOfString:@"《个人信息查询及使用综合授权书》"];
    [protocolTool addRichHelpWithType:ZHRichHelpTypeClick range:authorizationRange color:[UIColor mainThemeColor]];
    
    //承诺协议
    NSRange promiseRange = [[protocolTool getResultString].string rangeOfString:@"《客户非学生承诺函》"];
    [protocolTool addRichHelpWithType:ZHRichHelpTypeClick range:promiseRange color:[UIColor mainThemeColor]];
    
    return protocolTool;
}


@end
