//
//  QGCardNotificationTitleCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/12/31.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardNotificationContentCell.h"
#import "QGBasicUITool.h"
#import "QGCalendarManager.h"
@interface QGCardNotificationContentCell ()

/// 标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 时间
@property (nonatomic, strong) UILabel * timeLabel;

/// 内容区域
@property (nonatomic, strong) UILabel * contentLabel;

@end

@implementation QGCardNotificationContentCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentCenter];
        self.titleLabel.numberOfLines = 0;
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.left.inset(20);
            make.top.offset(16);
        }];
        
        //时间
        self.timeLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentRight];
        [self.timeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(20);
            make.top.mas_equalTo(self.titleLabel.mas_bottom).offset(18);
        }];
        
        //线条
        UIView * lineView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(self.timeLabel.mas_bottom).offset(5);
            make.height.mas_equalTo(0.5);
        }];
        
        //公告内容
        self.contentLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:14] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        self.contentLabel.numberOfLines = 0;
        [self.contentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(lineView.mas_bottom).offset(15);
        }];
        
    }
    return self;
}


- (void)setInfoModel:(QGNotifyInfoModel *)infoModel
{
    if (_infoModel != infoModel) {
        _infoModel = infoModel;
        self.titleLabel.text = _infoModel.title;
        self.contentLabel.attributedText = [_infoModel.contentTool getResultString];
        self.timeLabel.text = [[QGCalendarManager shareInstance] getDateStrFromSince1970:_infoModel.showStartTime formatter:@"yyyy年MM月dd日"];
    }
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
