//
//  QGCardViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/10.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGCardViewController.h"
#import "QGRepaymentGroupViewController.h"

//Model
#import "QGCardHomeModel.h"

//View
#import "QGCardBannerCell.h"
#import "QGRefreshNomalHeader.h"
#import "QGDefaultView.h"
#import "QGBasePopView.h"
#import "QGAlertView.h"
#import "QGCardAdvantageCell.h"
#import "QGCardHeaderUnActiveCell.h"
#import "QGCardHeaderReviewRejectCell.h"
#import "QGCardHeaderReviewSuccessCell.h"
#import "QGBindingCardCell.h"
#import "QGBindingCardAlertView.h"
#import "QGCardNotificationCell.h"
#import "QGCardQuickEntranceCell.h"
#import "QGCardAccountNormalCell.h"
#import "QGCardAccountReviewingCell.h"
#import "QGCardAccountReviewSuccessCell.h"
#import "QGCardBindingBottomView.h"

//Tool
#import "QGApplicationOpenURL.h"
#import "QGCardRequestApi.h"
#import "QGUserCenterRequestApi.h"
#import "QGCacheManager.h"
#import "QGDeviceTool.h"
#import "QGCardNormalStatusAnimationView.h"
#import "QGShareView.h"
#import "QGActivityPopView.h"
#import "QGActivityPopManager.h"
#import "QGFaceVerifyManager.h"
//友盟
#import <UMAnalytics/MobClick.h>

#import "QGDepositViewController.h"



@interface QGCardViewController ()

///首页数据模型
@property (nonatomic, strong) QGCardHomeModel * cardDataModel;

/// 消息按钮
@property (nonatomic, strong) UIButton * messageButton;

/// 客服按钮
@property (nonatomic, strong) UIButton * serviceButton;

/// 绑卡浮窗
@property (nonatomic, strong) QGCardBindingBottomView * bindingBottomView;
@end

@implementation QGCardViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initNormalUI];
    [self uploadIPAddress];
    

//    [self performSelector:@selector(showActivities) withObject:nil afterDelay:2.0];
}


//- (void)showActivities
//{
//    QGActivityPopManager *manager = [QGActivityPopManager shareInstance];
//    [manager showActivitiesAtPosition:QGActivityPositionHome inController:self];
//
//}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    //如果有数据则默默刷新 否则下拉刷新
    if (self.cardDataModel) {
        [self requestAllData];
    }
    else
    {
        //开始下拉刷新
        [self.tableView beginHeaderRefresh];
    }
    
    [QGActivityPopManager.shareInstance viewDidAppearAtPosition:QGActivityPositionHome inController:self];
}

- (void)initNormalUI
{
    self.tableViewStyle = UITableViewStyleGrouped;
    [self setNavBarBottomLineHidden:YES];
    self.isAboveTabBar = YES;
    self.title = @"享花卡";
    //添加下拉刷新
    [self addRefresh];
    self.tableView.backgroundColor = [UIColor whiteColor];
    
    ///空白的footer,占位没其他用途
    UIView *footerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, self.view.frame.size.width, 80)];
    self.tableView.tableFooterView = footerView;
    
    //添加右侧按钮，客服 & 消息
    self.messageButton = [self creatRightButtonWithImageName:@"message_right_barbutton"];
    [self.messageButton addTarget:self action:@selector(messageButtonClick) forControlEvents:UIControlEventTouchUpInside];
    self.serviceButton = [self creatRightButtonWithImageName:@"service_right_barbutton"];
    [self.serviceButton addTarget:self action:@selector(serviceButtonClick) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem * messageBtnItem = [[UIBarButtonItem alloc]initWithCustomView:self.messageButton];
    UIBarButtonItem * serviceBtnItem = [[UIBarButtonItem alloc]initWithCustomView:self.serviceButton];
    self.navigationItem.rightBarButtonItems = @[messageBtnItem,serviceBtnItem];
    
    //底部绑定视图
    self.bindingBottomView = [[QGCardBindingBottomView alloc] init];
    [self.view addSubview:self.bindingBottomView];
    self.bindingBottomView.hidden = YES;
    [self.bindingBottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.inset(15 + [DeviceAdaptation getTabBarHeight]);
        make.left.right.inset(15);
        make.height.mas_equalTo(40);
    }];
    
    @weakify(self);
    self.bindingBottomView.clickBlock = ^(BindingCardClickType type) {
        @strongify(self);
        [self addWalletClick:type];
    };
    
}

///添加下拉刷新
- (void)addRefresh
{
    @weakify(self);
   [self.tableView addHeaderRefreshOnlyWithHandle:^(BOOL isRefresh) {
        @strongify(self);
        [self requestAllData];
    }];
}

#pragma mark - request
///网络请求
- (void)requestAllData
{
    @weakify(self);
    NSString * urlString = [QGCardRequestApi urlWithIndex:QGCardRequestServerMethodBlanknoteStatus];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/mvp/index/v3";

//    NSDictionary * parameters = @{@"type":@"137"};
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        @strongify(self);
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * dataDic = responseObject[@"data"];
            self.cardDataModel = [QGCardHomeModel yy_modelWithDictionary:dataDic];

        }
        else
        {
            //如果第一次进来没有数据 则弹出重新加载按钮
            if (!self.cardDataModel) {
                QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
                //开始下拉刷新
                [self.tableView beginHeaderRefresh];
                }];
                view.viewType = QGDefaultViewTypeBadNetwork;
            }
            //业务错误弹出提示
            [QGHUDManager showHudWithError:responseObject];
        }
        [self.tableView endHeaderRefreshWithBlock:nil];
        [self.tableView reloadData];
        
        //tableView在初始位置的时候
        if (self.tableView.contentOffset.y == 0) {
            //底部绑卡是否展示
            BOOL hiddenBindingView = YES;
            //已激活二类户
            if (self.cardDataModel.blankNote.depositAccountStatusEnumType.integerValue == 1) {
                hiddenBindingView = !self.cardDataModel.blankNote.showCreditDesc.boolValue;
            }
            self.bindingBottomView.hidden = hiddenBindingView;
        }
        
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        @strongify(self);
        [self.tableView endHeaderRefreshWithBlock:nil];
        QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
           //开始下拉刷新
           [self.tableView beginHeaderRefresh];
        }];
        view.viewType = QGDefaultViewTypeBadNetwork;
    }];
    
    
    //登录状态下才请求
    if ([QGUserInfo sharedUserInfo].isLogin) {
        //请求未读消息数
        NSString *unreadUrl = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodUnread];
        NSMutableDictionary *noticesParame = [[NSMutableDictionary alloc] initWithCapacity:1];
        [noticesParame setObject:@"all" forKey:@"msgType"];
        [[QGTalosNetwork shareManager] GET:unreadUrl parameters:noticesParame success:^(id  _Nonnull responseObject) {
            //业务成功逻辑
            if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
                [QGUserInfo sharedUserInfo].unreadNumber = [responseObject valueForKeyPath:@"data.notifyMsgCount"];
                if ([QGUserInfo sharedUserInfo].unreadNumber.integerValue > 0) {
                    [self.messageButton setImage:[UIImage imageNamed:@"message_right_barbutton_hint"] forState:UIControlStateNormal];
                }else{
                    [self.messageButton setImage:[UIImage imageNamed:@"message_right_barbutton"] forState:UIControlStateNormal];
                }
            }
            
        } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
            
        }];
    }
    //未登录状态下清理消息状态
    else
    {
        [self.messageButton setImage:[UIImage imageNamed:@"message_right_barbutton"] forState:UIControlStateNormal];
    }
}




/// 上传IP和mac地址
- (void)uploadIPAddress
{
    if (![QGUserInfo isLogin]) {
        return;
    }
    
    NSString * urlStr = [QGCardRequestApi urlWithIndex:QGCardRequestServerMethodCacheIpMacAddress];
    NSMutableDictionary * infoDic = [NSMutableDictionary dictionaryWithCapacity:0];
    //ip地址和wifi mac地址
    NSString * IPAdress =  [QGDeviceTool getDeviceIPAdress];
    if (![NSString isEmpty:IPAdress]) {
        [infoDic setValue:IPAdress forKey:@"ipAddress"];
    }
    NSString * wifiBSSID = [QGDeviceTool getWifiBSSID];
    if (![NSString isEmpty:wifiBSSID]) {
        [infoDic setValue:wifiBSSID forKey:@"macAddress"];
    }
    
    [[QGTalosNetwork shareManager] POST:urlStr parameters:infoDic success:^(id  _Nonnull responseObject) {
        NSLog(@"bind ip success");
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSLog(@"bind ip failure");
    }];
}

///获取授信URL并跳转
- (void)requestCreditUrlAndJump
{
    NSString * urlStr = [QGCardRequestApi urlWithIndex:QGCardRequestServerMethodActiveCreditUrl];
//    urlStr = @"http://yapi.quantgroups.com/mock/305/vcc/account/active_credit_limit_url";
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] GET:urlStr parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSString * jumpUrl = responseObject[@"data"][@"url"];
            //非空就能跳转
            if(![NSString isEmpty:jumpUrl])
            {
                [QGApplicationOpenURL handleAllSupportUrl:jumpUrl callbackBolck:nil];
            }
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}

///请求储蓄账户
- (void)requestSavingsAccount
{
    NSString * urlString = [QGCardRequestApi urlWithIndex:QGCardRequestServerMethodSavingsAccountQuery];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/debit/account_balance/query";
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSString * amount = responseObject[@"data"][@"amount"];
            if (amount) {
                //存储金额并且刷新
                self.cardDataModel.blankNote.depositAmount = [NSString stringWithFormat:@"%@",amount];
                [self.tableView reloadData];
            }
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        
    }];
}



#pragma mark - UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return self.cardDataModel ? 7 : 0;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = 1;
    switch (section) {
            //公告
        case 0:
            numberOfRows = self.cardDataModel.blankNote.notifyInfoList.count > 0 ? 1 : 0;
            break;
            //享花卡
        case 1:
            numberOfRows = self.cardDataModel.blankNote ? 1 : 0;
            break;
            //快捷入口
        case 2:
            numberOfRows = self.cardDataModel.blankNote.quickEntranceList.count > 0 ? 1 : 0;
            break;
            //信用账户和储蓄账户展示
        case 3:
            numberOfRows = self.cardDataModel.blankNote.depositAccountStatusEnumType.integerValue == 1 ? 1 : 0;
            break;
            //banner
        case 4:
            numberOfRows = self.cardDataModel.loanBanner.count > 0 ? 1 : 0;
            break;
            //三大优势
        case 5:
            numberOfRows = self.cardDataModel.blankNote.saveMoneyConfigList.count > 0 ? 1 : 0;
            break;
        //立即绑卡
        case 6:
        {
            //已激活二类户
            if (self.cardDataModel.blankNote.depositAccountStatusEnumType.integerValue == 1) {
                numberOfRows = self.cardDataModel.blankNote.showCreditDesc.boolValue ? 1 : 0;
            }
            else
            {
                numberOfRows = 0;
            }
        }
            
            break;
        default:
            break;
    }
    return numberOfRows;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section) {
            //公告
        case 0:
        {
            QGCardNotificationCell * cell = (QGCardNotificationCell *)[self getCellFromClassName:NSStringFromClass([QGCardNotificationCell class]) dequeueTableView:tableView];
            cell.notificationArray = self.cardDataModel.blankNote.notifyInfoList;
            @weakify(self);
            cell.clickBlock = ^(NSInteger index) {
                @strongify(self);
                [self jumpNotificationPage:index];
            };
            return cell;
        }
            break;
            //顶部享花卡区域
        case 1:
        {
            return [self getCardHeaderCellWithTableView:tableView];
        }
            break;
            //快捷入口
        case 2:
        {
            QGCardQuickEntranceCell * cell = (QGCardQuickEntranceCell *)[self getCellFromClassName:NSStringFromClass([QGCardQuickEntranceCell class]) dequeueTableView:tableView];
            cell.cashbackList = self.cardDataModel.blankNote.quickEntranceList;
            @weakify(self);
            cell.clickBlock = ^(NSInteger index, QGQuickEntranceModel * _Nonnull quickEntrymodel) {
                @strongify(self);
                [self jumpQuickEntrance:index model:quickEntrymodel];
            };
            return cell;
        }
            //储蓄账户和信用账户
        case 3:
        {
            return [self getCardAccountCellWithTableView:tableView];
        }
            break;
            //banner
        case 4:
        {
            @weakify(self);
            QGCardBannerCell * cell = (QGCardBannerCell *)[self getCellFromClassName:NSStringFromClass([QGCardBannerCell class]) dequeueTableView:tableView];
            cell.banners = self.cardDataModel.loanBanner;
            cell.bannerClickBlock = ^(NSInteger index) {
                @strongify(self);
                [self bannerClickBlock:index];
            };
            return cell;
        }
            break;
            //三大优势
        case 5:
        {
            QGCardAdvantageCell * cell = (QGCardAdvantageCell *)[self getCellFromClassName:NSStringFromClass([QGCardAdvantageCell class]) dequeueTableView:tableView];
            cell.imagesArray = self.cardDataModel.blankNote.saveMoneyConfigList;
            
            @weakify(self);
            //点击事件
            cell.clickBlock = ^(NSInteger index) {
                @strongify(self);
                [self advantageClickWithIndex:index];
            };
            
            return cell;
        }
            break;
            //立即绑卡
        case 6:
        {
            QGBindingCardCell * cell = (QGBindingCardCell *)[self getCellFromClassName:NSStringFromClass([QGBindingCardCell class]) dequeueTableView:tableView];
            @weakify(self);
            cell.openWalletBlock = ^(BindingCardClickType type) {
                @strongify(self);
                [self addWalletClick:type];
            };
            return cell;
            
        }
            break;
            
        default:
            break;
    }
    

    UITableViewCell * cell = [UITableViewCell new];
    return cell;
}

///获取顶部享花卡cell
- (UITableViewCell *)getCardHeaderCellWithTableView:(UITableView *)tableView
{
    QGCardBaseHeaderCell * cell;
    QGBlankNoteModel * blanNoteModel = self.cardDataModel.blankNote;
    
    @weakify(self);
    /// 二类户账户状态 0-初始状态，1-激活成功，2-激活失败
    switch (blanNoteModel.depositAccountStatusEnumType.integerValue) {
            //初始状态
        case 0:
        {
            QGCardHeaderUnActiveCell * normalCell = (QGCardHeaderUnActiveCell *)[self getCellFromClassName:NSStringFromClass([QGCardHeaderUnActiveCell class]) dequeueTableView:tableView];
            cell = normalCell;
            
            //激活按钮点击事件
            [normalCell.activateButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                @strongify(self);
                [self activateButtonClick];
            }];
        }
            break;
            //激活成功
        case 1:
        {
            QGCardHeaderReviewSuccessCell * reviewSuccessCell = (QGCardHeaderReviewSuccessCell *)[self getCellFromClassName:NSStringFromClass([QGCardHeaderReviewSuccessCell class]) dequeueTableView:tableView];
            //立即绑定
            [reviewSuccessCell.bindingCardButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                
                [tableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:6] atScrollPosition:UITableViewScrollPositionNone animated:YES];
            }];
            cell = reviewSuccessCell;
        }
            break;
            //激活失败
        case 2:
        {
            QGCardHeaderReviewRejectCell * rejectCell = (QGCardHeaderReviewRejectCell *)[self getCellFromClassName:NSStringFromClass([QGCardHeaderReviewRejectCell class]) dequeueTableView:tableView];
            cell = rejectCell;
            
            //激活按钮点击事件
            [rejectCell.activateButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                @strongify(self);
                [self activateButtonClick];
            }];
            
        }
            break;
            
        default:
            break;
    }
    
    cell.blanNoteModel = blanNoteModel;
    return cell ? cell : [UITableViewCell new];
}


///获取账户cell相关
- (UITableViewCell *)getCardAccountCellWithTableView:(UITableView *)tableView
{
    @weakify(self);
    QGCardAccountBaseCell * accountBaseCell;
    /// 信用账户状态 0-初始状态，1-激活成功，2-激活失败，4-审核中
    NSInteger creditStatus = self.cardDataModel.blankNote.creditAccountStatusEnumType.integerValue;
    switch (creditStatus) {
            //初始状态
        case 0:
        {
            QGCardAccountNormalCell * cell = (QGCardAccountNormalCell *)[self getCellFromClassName:NSStringFromClass([QGCardAccountNormalCell class]) dequeueTableView:tableView];
            accountBaseCell = cell;
            
            //激活按钮，此处需要请求接口，跳转H5或者原生页
            [cell.activeButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                @strongify(self);
                //埋点
                QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"享花卡页" path:@"信用账户" name:@"激活额度" detail_name:nil];
                [QGAnalyticsService analyticsTrackWithEvent:event];
                
                [self requestCreditUrlAndJump];
            }];
        }
            break;
            //激活失败或者审核中
        case 2:
        case 4:
        {
            QGCardAccountReviewingCell * cell = (QGCardAccountReviewingCell *)[self getCellFromClassName:NSStringFromClass([QGCardAccountReviewingCell class]) dequeueTableView:tableView];
            accountBaseCell = cell;
        }
            break;
            //激活成功
        case 1:
        {
            QGCardAccountReviewSuccessCell * cell = (QGCardAccountReviewSuccessCell *)[self getCellFromClassName:NSStringFromClass([QGCardAccountReviewSuccessCell class]) dequeueTableView:tableView];
            accountBaseCell = cell;
            
            //还款
            [cell.repaymentButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                @strongify(self);
                [self paymentClickBlock];
                //埋点
                QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"享花卡页" path:@"信用账户" name:@"立即还款" detail_name:nil];
                [QGAnalyticsService analyticsTrackWithEvent:event];
            }];
            
            //额度管理
            [cell.quotaButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                @strongify(self);
                [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGQuotaManagerViewController) parameters:nil handlerBlock:nil];
                
                NSString * modelName = @"额度管理";
                if (self.cardDataModel.blankNote.isHasQuotaFlag.boolValue) {
                    modelName = @"额度管理（有提额包）";
                }
                //埋点
                QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"享花卡页" path:@"信用账户" name:modelName detail_name:nil];
                [QGAnalyticsService analyticsTrackWithEvent:event];
            }];
            
        }
            break;
            
        default:
            break;
    }
    
    if (accountBaseCell) {
        accountBaseCell.dataModel = self.cardDataModel;
        
        //账单
        [accountBaseCell.creditView.billSubCell.subCellClickButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGRepaymentGroupViewController) parameters:nil handlerBlock:nil];
            //埋点
            QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"享花卡页" path:@"信用账户" name:@"查看账单" detail_name:nil];
            [QGAnalyticsService analyticsTrackWithEvent:event];
        }];
        
        //设置分期
        [accountBaseCell.creditView.configTermSubCell.subCellClickButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self jumpSelectTermPage];
            //埋点
            QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"享花卡页" path:@"信用账户" name:@"设置分期" detail_name:nil];
            [QGAnalyticsService analyticsTrackWithEvent:event];
        }];
        
        //账户明细
        accountBaseCell.savingsView.detailClickBlock = ^{
            @strongify(self);
            if (![NSString isEmpty:self.cardDataModel.blankNote.debitRecordListUrl]) {
                [self navigationToWeb:self.cardDataModel.blankNote.debitRecordListUrl];
            }
        };
        
        //首充点击
        accountBaseCell.savingsView.rechargeGiftClickBlock = ^{
            @strongify(self);
            if (![NSString isEmpty:self.cardDataModel.blankNote.firstDepositAd.jumpUrl]) {
                [self navigationToWeb:self.cardDataModel.blankNote.firstDepositAd.jumpUrl];
            }
        };
        //转入
        [accountBaseCell.savingsView.intoButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self jumpDepositWithType:1];
            //埋点
            QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"享花卡页" path:@"储蓄账户" name:@"转入" detail_name:nil];
            [QGAnalyticsService analyticsTrackWithEvent:event];
        }];
        
        //转出
        [accountBaseCell.savingsView.outButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self jumpDepositWithType:2];
            //埋点
            QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"享花卡页" path:@"储蓄账户" name:@"转出" detail_name:nil];
            [QGAnalyticsService analyticsTrackWithEvent:event];
        }];
        
        //重新请求储蓄卡金额并刷新
        accountBaseCell.reloadSavingsAmount = ^{
            @strongify(self);
            [self requestSavingsAccount];
        };

    }
    return accountBaseCell ? accountBaseCell : [UITableViewCell new];
}


#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSInteger heightForRow = CGFLOAT_MIN;
    switch (indexPath.section) {
            //公告
        case 0:
            heightForRow = 45;
            break;
            //享花卡
        case 1:
            heightForRow = [QGCardBaseHeaderCell cellHeight];
            break;
            //快捷入口
        case 2:
            heightForRow = 100;
            break;
            //储蓄账户和信用账户
        case 3:
            heightForRow = 282;
            break;
            //banner
        case 4:
            heightForRow = [QGCardBannerCell cellHeight];
            break;
            //三大优势
        case 5:
            heightForRow = 163;
            break;
        //立即绑卡
        case 6:
            heightForRow = 145;
            break;
        default:
            break;
    }
    return heightForRow;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    //储蓄账户、信用账户
    if (section == 3) {
        return 10;
    }
    return CGFLOAT_MIN;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView * view;
    //储蓄账户、信用账户
    if (section == 3) {
        view = [UIView creatViewWithSuperView:nil backgroundColor:[UIColor moduleSeparatorColorF7F7]];
    }
    return view;
}

- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    if (scrollView.contentOffset.y > 0) {
        self.bindingBottomView.hidden = YES;
    }
    else
    {
        BOOL hiddenBindingView = YES;
        //已激活二类户
        if (self.cardDataModel.blankNote.depositAccountStatusEnumType.integerValue == 1) {
            hiddenBindingView = !self.cardDataModel.blankNote.showCreditDesc.boolValue;
        }
        self.bindingBottomView.hidden = hiddenBindingView;
    }
}

#pragma mark - Action

/// 消息点击事件
- (void)messageButtonClick
{
    if ([QGUserInfo sharedUserInfo].login) {//去到消息中心
        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGMessageCenterVC] parameters:nil handlerBlock:nil];
    }else{
        [self showLoginViewController];
    }
}

/// 客服点击事件
- (void)serviceButtonClick
{
    if ([QGUserInfo sharedUserInfo].login) {
       [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGBaseWebViewController) parameters:@{@"urlString":VCCServiceUrl} handlerBlock:nil];
    }else{
        [self showLoginViewController];
    }
}

///激活按钮点击事件
- (void)activateButtonClick
{
    
    if (![QGUserInfo isLogin]) {
        [self showLoginViewControllerCompletion:nil];
        return;
    }

    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] GET:[QGCardRequestApi urlWithIndex:QGCardRequestServerMethodActiveUrl] parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHudAnimated:YES];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * dataDic = responseObject[@"data"];
            //激活页面URL 每次跳转需要重新请求
            NSString * activateUrl = dataDic[@"url"];
              [self checkUrlAndJumpWithuUrlString:activateUrl];

          
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSString * errorMessage = [QGBaseNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorMessage];
    }];
}


///立即还款
- (void)paymentClickBlock
{
    
    NSInteger repayBillStatusEnumType = self.cardDataModel.blankNote.repayBillStatusEnumType.integerValue;
    /**
    * 还款账单状态
    * 2：已消费，未出账
    * 5：还款成功
    */
    if (repayBillStatusEnumType == 2 || repayBillStatusEnumType == 5) {
        if (![NSString isEmpty:self.cardDataModel.blankNote.appPreRepayUrl]) {
           [QGApplicationOpenURL handleAllSupportUrl:self.cardDataModel.blankNote.appPreRepayUrl];
        }
        else
        {
            [QGHUDManager showHud:@"无效的URL"];
        }
    }
    else
    {
        if (![NSString isEmpty:self.cardDataModel.blankNote.appRepayUrl]) {
            [QGApplicationOpenURL handleAllSupportUrl:self.cardDataModel.blankNote.appRepayUrl];
        }
        else
        {
            [QGHUDManager showHud:@"无效的URL"];
        }
    }
    
    
    
}


///检查URL并跳转
- (void)checkUrlAndJumpWithuUrlString:(NSString *)urlString
{
    
    @weakify(self);
    //此处产品要求所有的跳转和回调能够连成一条线。因此只支持URL和活体协议
    XYQBJumpType jumpType =  [[QGApplicationOpenURL shareInstance] autoParseURL:[NSURL URLWithString:urlString]];
    if (jumpType == XYQBJumpTypeHttp)
    {
        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeCWWebViewController] parameters:@{@"urlString":urlString} handlerBlock:^(NSString *tag, NSDictionary *parameters) {
            @strongify(self);
            if ([tag isEqualToString:WebView_ReopenBrowserWithNewUrl]) {
                NSString * urlString = parameters[@"urlString"];
                //不管回来的是什么样的URL，进行递归操作
                [self checkUrlAndJumpWithuUrlString:urlString];
            }

        }];
    }
    //如果是活体
    else if (jumpType == XYQBJumpTypeFaceEntrance)
    {
        
        [QGFaceVerifyManager.shareInstance openFaceVerifySuccess:^{
            @strongify(self);
            [MobClick event:@"AppFaceLivingSuccess"];
            [self activateButtonClick];
        }];
        
    }
    //如果运营人员配错其他页面也能支持跳转
    else
    {
        [QGApplicationOpenURL handleAllSupportUrl:urlString callbackBolck:nil];
    }
    
    
}

///优势点击事件
- (void)advantageClickWithIndex:(NSInteger)index
{
    QGSaveMoneyConfigModel * configModel = self.cardDataModel.blankNote.saveMoneyConfigList[index];
    if (configModel.loginFlag.boolValue && ![QGUserInfo isLogin]) {
        [self showLoginViewController];
        return;
    }
    
    //埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"享花卡页" path:@"省钱推荐" name:@"Banner" detail_name:configModel.name acmc_model_other:configModel.jumpUrl];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    if (![NSString isEmpty:configModel.jumpUrl]) {
        [QGApplicationOpenURL handleAllSupportUrl:configModel.jumpUrl];
    }
    else
    {
        [QGHUDManager showHud:@"无效链接"];
    }
}

///banner跳转
- (void)bannerClickBlock:(NSInteger)index
{
    QGCardBannerModel * bannerModel = self.cardDataModel.loanBanner[index];
    if (![NSString isEmpty:bannerModel.navUrl]) {
        [QGApplicationOpenURL handleAllSupportUrl:bannerModel.navUrl];
    }
    else
    {
        [QGHUDManager showHud:@"无效链接"];
    }
}


/// 跳转快捷入口
- (void)jumpQuickEntrance:(NSInteger)index model:(QGQuickEntranceModel *)listModel
{
    //埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"享花卡页" path:@"卡面下4个功能按钮" name:listModel.name detail_name:nil];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    if (![QGUserInfo isLogin]) {
        [self showLoginViewController];
        return;
    }
    
    /// 二类户账户状态 0-初始状态，1-激活成功，2-激活失败
    if (self.cardDataModel.blankNote.depositAccountStatusEnumType.integerValue != 1) {
        [QGHUDManager showHud:@"请先开通享花卡"];
        return;
    }
    
    XYQBJumpType jumpType = [[QGApplicationOpenURL shareInstance] autoParseURL:[NSURL URLWithString:listModel.jumpUrl]];
    //信用账户状态 0-初始状态，1-激活成功，2-激活失败，4-审核中
    NSInteger creditStatus = self.cardDataModel.blankNote.creditAccountStatusEnumType.integerValue;
    //跳转账单时需要检测用户是否已经开通信用账户
    if (jumpType == XYQBJumpTypeVirtualBill && creditStatus != 1) {
        QGAlertView * alert = [[QGAlertView alloc] initWithTitle:nil message:@"享花卡额度尚未激活，请先激活额度" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:nil];
        [alert showInView:nil];
        return;
    }
    
    if (![NSString isEmpty:listModel.jumpUrl]) {
        [QGApplicationOpenURL handleAllSupportUrl:listModel.jumpUrl callbackBolck:nil];
    }
}


///设置分期
- (void)jumpSelectTermPage
{
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGSelectTermViewController) parameters:nil handlerBlock:nil];
}


/// 跳转到通知页
- (void)jumpNotificationPage:(NSInteger)index
{
    if (index < self.cardDataModel.blankNote.notifyInfoList.count &&  index >= 0) {
        QGNotifyInfoModel * infoModel = self.cardDataModel.blankNote.notifyInfoList[index];
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGCardNotificationController) parameters:@{@"infoModel":infoModel} handlerBlock:nil];
    }
    
}

///添加到钱包
- (void)addWalletClick:(BindingCardClickType)type
{
    
    //未激活，则跳转激活流程
    if (self.cardDataModel.blankNote.headerType == HomeCardHeaderTypeCardUnActive) {
        [self activateButtonClick];
    }
    //已激活
    else
    {
        //手机钱包
        if (type == BindingCardClickTypeWallet) {
            NSMutableDictionary * param = [NSMutableDictionary dictionaryWithCapacity:0];
            if (![NSString isEmpty:self.cardDataModel.blankNote.sySecondAccountCardNo]) {
                [param setObject:self.cardDataModel.blankNote.sySecondAccountCardNo forKey:@"cardNo"];
            }
            [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGBindingWalletController] parameters:param handlerBlock:nil];
        }
        else
        {
            QGBindingCardAlertView * alipayAlert = [[QGBindingCardAlertView alloc] init];
            if (type == BindingCardClickTypeAlipay) {
                alipayAlert.alertViewType = BindingCardAlertViewTypeAlipay;
            }
            else if (type == BindingCardClickTypeWechat)
            {
                alipayAlert.alertViewType = BindingCardAlertViewTypeWechat;
            }
            alipayAlert.cardNumLabel.text = [self.cardDataModel.blankNote.sySecondAccountCardNo formatterBankCardNum];
            [alipayAlert showInView:nil];
        }
    }

}


/// 转入转出

- (void)jumpDepositWithType:(NSInteger)type
{
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGDepositeRecordedViewController) parameters:@{@"type":@(type)} handlerBlock:NULL];
}

#pragma mark - Creat

/// 创建右上角按钮 此处仅适用于有多个的情况
- (UIButton *)creatRightButtonWithImageName:(NSString *)imageName
{
    UIButton * rightButton = [UIButton buttonWithType:UIButtonTypeCustom];
    [rightButton setImage:[UIImage imageNamed:imageName] forState:UIControlStateNormal];
    rightButton.bounds = CGRectMake(0, 0, 34, 40);
    return rightButton;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
