//
//  QGCardNotificationCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/12/31.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardNotificationCell.h"
#import "QGMarqueeView.h"
#import "QGBasicUITool.h"

@interface QGCardNotificationCell ()

/// 公告
@property (nonatomic, strong) QGMarqueeView * notificationView;

@end

@implementation QGCardNotificationCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
//        self.backgroundColor = [UIColor colorWithHexString:@"F9F3DD"];
        
        UIView *contentBackView = [[UIView alloc]init];
        contentBackView.backgroundColor =[UIColor colorWithHexString:@"F9F3DD"];
        
        [self.contentView addSubview:contentBackView];
        
        [contentBackView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.inset(0);
            make.left.right.inset(0);
            make.bottom.inset(6);
        }];
        
        //消息通知
        self.notificationView = [[QGMarqueeView alloc] init];
        self.notificationView.textColor = [UIColor colorWithHexString:@"EBB45F"];
        [contentBackView addSubview:self.notificationView];
        [self.notificationView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.bottom.inset(0);
            make.left.right.inset(20);
        }];
        
        @weakify(self);
        self.notificationView.clickEventBlock = ^(NSInteger index) {
            @strongify(self);
            if (self.clickBlock) {
                self.clickBlock(index);
            }
        };
    }
    return self;
}

- (void)setNotificationArray:(NSArray<QGNotifyInfoModel *> *)notificationArray
{
    if (_notificationArray != notificationArray) {
        _notificationArray = notificationArray;
        
        //通知
        NSMutableArray * titleArray = [NSMutableArray arrayWithCapacity:0];
        for (QGNotifyInfoModel * infoModel in _notificationArray) {
            [titleArray addObject:infoModel.title];
        }
        self.notificationView.textArray = titleArray;
        
    }
}



- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
