//
//  QGCardBannerCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/6/21.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardBannerCell.h"

#import "QGBannerView.h"
#import "QGBasicUITool.h"

@interface QGCardBannerCell ()<QGBannerViewDelegate>

/**
 banner视图
 */
@property (nonatomic, strong) QGBannerView * bannerView;

@end

@implementation QGCardBannerCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        [self initNormalUI];
    }
    return self;
}

//初始化默认视图
- (void)initNormalUI
{
    //初始化banner
    self.bannerView = [QGBannerView bannerViewWithFrame:CGRectMake(0, 20, MAINSCREEN_WIDTH, MAINSCREEN_WIDTH * (90/375.0)) delegate:self placeholderImage:nil];
    self.bannerView.autoScrollTimeInterval = 3;
    self.bannerView.pageMidIndent = 4;
    [self.contentView addSubview:self.bannerView];
}


#pragma mark - QGBannerViewDelegate
/** 点击图片回调 */
- (void)bannerView:(QGBannerView *)bannerView didSelectItemAtIndex:(NSInteger)index
{
    if (self.bannerClickBlock) {
        if (self.banners.count > index) {
            self.bannerClickBlock(index);
        }
    }
}

- (void)setBanners:(NSArray<QGCardBannerModel *> *)banners
{
    if (_banners != banners) {
        _banners = banners;
        
        NSMutableArray * urlArray = [NSMutableArray arrayWithCapacity:0];
        for (QGCardBannerModel * bannerModel in banners) {
            [urlArray addObject:bannerModel.imgUrl];
        }
        self.bannerView.imageUrlArray = urlArray;
    }
}


/**
 cell高度
 */
+ (CGFloat)cellHeight
{
    CGFloat width = MAINSCREEN_WIDTH;
    CGFloat height = width * (90/375.0);
    return height + 40;
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
