//
//  QGCardAdvantageCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/24.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardAdvantageCell.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"
@interface QGCardAdvantageCell ()<UICollectionViewDataSource, UICollectionViewDelegate>
///图片展示区域
@property (nonatomic, strong) UICollectionView * collectionView;
@end

@implementation QGCardAdvantageCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        //标题
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"省钱推荐" titleFontSize:[UIFont qg_mediumFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.inset(20);
            make.height.mas_equalTo(25);
        }];
        
        //图片展示区域
        UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc] init];
        layout.sectionInset = UIEdgeInsetsMake(0, 20, 0, 20);
        layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
        layout.itemSize = CGSizeMake(180, 95);
        layout.minimumLineSpacing = 10;
        layout.minimumInteritemSpacing = 0;
        self.collectionView = [[UICollectionView alloc]initWithFrame:CGRectZero collectionViewLayout:layout];
        self.collectionView.dataSource = self;
        self.collectionView.delegate = self;
        self.collectionView.backgroundColor = [UIColor whiteColor];
        [self.contentView addSubview:self.collectionView];
        
        [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(0);
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(15);
            make.height.mas_equalTo(95);
        }];
        self.collectionView.showsHorizontalScrollIndicator = NO;
        
        [self.collectionView registerClass:[QGCardAdvantageCollectionCell class] forCellWithReuseIdentifier:NSStringFromClass([QGCardAdvantageCollectionCell class])];
    }
    return self;
}


- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.imagesArray.count;
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGCardAdvantageCollectionCell * cell = (QGCardAdvantageCollectionCell *)[collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGCardAdvantageCollectionCell class]) forIndexPath:indexPath];
    
    QGSaveMoneyConfigModel * configModel = self.imagesArray[indexPath.row];
    [cell.infoImageView setImageByNomalPlaceholderWithURLString:configModel.imgUrl];
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.clickBlock) {
        self.clickBlock(indexPath.row);
    }
}



- (void)setImagesArray:(NSArray <QGSaveMoneyConfigModel *>*)imagesArray
{
    if (_imagesArray != imagesArray) {
        _imagesArray = imagesArray;
        [self.collectionView reloadData];
    }
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end



@implementation QGCardAdvantageCollectionCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        self.infoImageView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.infoImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.offset(0);
        }];
    }
    return self;
}


@end
