//
//  QGCardCreditAccountView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/31.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCardCreditAccountView.h"
#import "QGBasicUITool.h"
@interface QGCardCreditAccountView ()

/// 阴影视图
@property (nonatomic, strong, readwrite) UIView * shadowContentView;

/// 账单cell
@property (nonatomic, strong, readwrite) QGCardBillSubView * billSubCell;

/// 设置分期cell
@property (nonatomic, strong, readwrite) QGCardBillSubView * configTermSubCell;

@end

@implementation QGCardCreditAccountView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //阴影视图
        self.shadowContentView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor whiteColor]];
        [self.shadowContentView setShadowColor:[UIColor shadowColor] shadowRadius:3 shadowOffset:CGSizeMake(0, 1) cornerRadius:6];
        [self.shadowContentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.bottom.top.inset(5);
        }];
        
        //分割线
        UIView * lineView = [UIView creatViewWithSuperView:self.shadowContentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.height.mas_equalTo(0.5);
            make.bottom.inset(80.5);
        }];
        
        /*************账单和设置分期*************/
        
        //我的账单
        self.billSubCell = [[QGCardBillSubView alloc] init];
        [self.shadowContentView addSubview:self.billSubCell];
        [self.billSubCell mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(0);
            make.bottom.inset(0);
            make.height.mas_equalTo(80);
            make.width.mas_equalTo(self.shadowContentView.mas_width).multipliedBy(0.5);
        }];
        
        self.billSubCell.titleLabel.text = @"我的账单";
        self.billSubCell.rightIconImageView.image = [UIImage imageNamed:@"card_bill"];
        self.billSubCell.showLabel.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        self.billSubCell.showLabel.text = @"去看看>>";
        
        
        //设置分期
        self.configTermSubCell = [[QGCardBillSubView alloc] init];
        [self.shadowContentView addSubview:self.configTermSubCell];
        [self.configTermSubCell mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(0);
            make.top.width.height.mas_equalTo(self.billSubCell);
        }];
        self.configTermSubCell.titleLabel.text = @"设置分期期数";
        self.configTermSubCell.rightIconImageView.image = [UIImage imageNamed:@"card_bill_config_term"];
        self.configTermSubCell.showLabel.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        self.configTermSubCell.showLabel.text = @"去修改>>";
        
        //中间分割线
        UIView * centerLineView = [UIView creatViewWithSuperView:self.shadowContentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [centerLineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(0.5, 40));
            make.centerX.offset(0);
            make.centerY.mas_equalTo(self.billSubCell);
        }];
    }
    return self;
}

@end
