//
//  QGCardAccountSegmentView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/31.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCardAccountSegmentView.h"
#import "QGBasicUITool.h"
#import "QGDesignatedCornerView.h"

@interface QGCardAccountSegmentView ()

/// 信用账户
@property (nonatomic, strong) UIButton * creditButton;

/// 储蓄账户
@property (nonatomic, strong) UIButton * savingsButton;

/// 选中的按钮
@property (nonatomic, strong) UIButton * selectButton;

/// 标签
@property (nonatomic, strong) QGDesignatedCornerView * tagView;

/// 标签
@property (nonatomic, strong) UILabel * tagLabel;

@end

@implementation QGCardAccountSegmentView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //信用账户
        self.creditButton = [UIButton creatButtonWithSuperView:self title:@"信用账户" titleFont:[UIFont qg_regularFontOfSize:18] textColor:[UIColor textColor9999]];
        self.creditButton.tag = 1;
        [self.creditButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(0);
            make.centerY.offset(0);
        }];
        [self.creditButton addTarget:self action:@selector(buttonClick:) forControlEvents:UIControlEventTouchUpInside];
        
        //分割线
        UIView * lineView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.creditButton.mas_right).offset(10.5);
            make.size.mas_equalTo(CGSizeMake(0.5, 20));
            make.centerY.mas_equalTo(self.creditButton);
        }];
        
        //储蓄账户
        self.savingsButton = [UIButton creatButtonWithSuperView:self title:@"储蓄账户" titleFont:[UIFont qg_regularFontOfSize:18] textColor:[UIColor textColor9999]];
        [self.savingsButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(lineView.mas_right).offset(10.5);
            make.centerY.mas_equalTo(self.creditButton);
        }];
        self.savingsButton.tag = 2;
        [self.savingsButton addTarget:self action:@selector(buttonClick:) forControlEvents:UIControlEventTouchUpInside];
        
        //默认选中第一个
        self.selectButton = self.creditButton;
        
        //红色小标签
        self.tagView = [[QGDesignatedCornerView alloc] initWithRadius:4 corner:UIRectCornerTopLeft | UIRectCornerTopRight | UIRectCornerBottomRight];
        self.tagView.backgroundColor = [UIColor colorWithHexString:@"FF2121"];
        [self addSubview:self.tagView];
        [self.tagView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.height.mas_equalTo(14);
            make.centerX.mas_equalTo(self.savingsButton.mas_right);
            make.bottom.mas_equalTo(self.savingsButton.mas_top).offset(7);
        }];
        
        //标签label
        self.tagLabel = [UILabel creatLabelWithSuperView:self.tagLabel title:nil titleFontSize:[UIFont qg_mediumFontOfSize:9] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        [self.tagView addSubview:self.tagLabel];
        [self.tagLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(4);
            make.top.bottom.inset(0);
            make.width.mas_lessThanOrEqualTo(220);
        }];
        
        
    }
    return self;
}

#pragma mark - Setter
- (void)setSelectButton:(UIButton *)selectButton
{
    if (_selectButton != selectButton) {
        //清除旧按钮的选中状态
        if (_selectButton) {
            _selectButton.titleLabel.font = [UIFont qg_regularFontOfSize:18];
            [_selectButton setTitleColor:[UIColor textColor9999] forState:UIControlStateNormal];
        }
        _selectButton = selectButton;
        //改变选中按钮的状态
        _selectButton.titleLabel.font = [UIFont qg_mediumFontOfSize:18];
        [_selectButton setTitleColor:[UIColor textColor3333] forState:UIControlStateNormal];
    }
}

///设置标签
- (void)setTagString:(NSString *)tagString
{
    self.tagView.hidden = [NSString isEmpty:tagString];
    self.tagLabel.text = tagString;
}


#pragma mark - Action
/// 信用账户和储蓄账户点击事件
- (void)buttonClick:(UIButton *)button
{
    self.selectButton = button;
    if (self.selectBlock) {
        self.selectBlock(button.tag);
    }
}


/// 外部选中事件
- (void)resetSelectButton:(QGAccountSegmentViewSelectType)selectType
{
    UIButton * selectButton = [self viewWithTag:selectType];
    if (selectButton && [selectButton isKindOfClass:[UIButton class]]) {
        self.selectButton = selectButton;
    }
}



@end
