//
//  QGCardAccountCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/31.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCardAccountBaseCell.h"
#import "QGCardAccountSegmentView.h"
#import "QGBasicUITool.h"

@interface QGCardAccountBaseCell ()

/// 顶部选择控件
@property (nonatomic, strong) QGCardAccountSegmentView * segmentView;

/// 信用账户
@property (nonatomic, strong, readwrite) QGCardCreditAccountView * creditView;

/// 储蓄账户视图
@property (nonatomic, strong, readwrite) QGCardSavingsAccountView * savingsView;

@end

@implementation QGCardAccountBaseCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //顶部选择控件
        self.segmentView = [[QGCardAccountSegmentView alloc] init];
        [self.contentView addSubview:self.segmentView];
        [self.segmentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.inset(18);
            make.height.mas_equalTo(25);
        }];
        
        //底部滑动容器
        UIScrollView * scrollView = [[UIScrollView alloc] init];
        scrollView.showsHorizontalScrollIndicator = NO;
        scrollView.showsVerticalScrollIndicator = NO;
        scrollView.scrollEnabled = NO;
        [self.contentView addSubview:scrollView];
        [scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(0);
            make.top.mas_equalTo(self.segmentView.mas_bottom).offset(9);
            make.bottom.inset(10);
        }];
        //给内部容器上下留5px的距离
        scrollView.contentSize = CGSizeMake(MAINSCREEN_WIDTH * 2, 220);
        
        //信用账户
        self.creditView = [[QGCardCreditAccountView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 220)];
        [scrollView addSubview:self.creditView];
    
        //储蓄账户
        self.savingsView = [[QGCardSavingsAccountView alloc] initWithFrame:CGRectMake(MAINSCREEN_WIDTH, 0, MAINSCREEN_WIDTH, 220)];
        [scrollView addSubview:self.savingsView];
        
        
        @weakify(self);
        self.segmentView.selectBlock = ^(QGAccountSegmentViewSelectType selectType) {
            @strongify(self);
            [scrollView setContentOffset:CGPointMake((selectType - 1) * MAINSCREEN_WIDTH, 0)];
            //每次切到储蓄账户需要刷新一下
            if (selectType == QGAccountSegmentViewSelectTypeSavings) {
                if (self.reloadSavingsAmount) {
                    self.reloadSavingsAmount();
                }
            }
        };
        
    }
    return self;
}

#pragma mark - Setter
- (void)setDataModel:(QGCardHomeModel *)dataModel
{
    if (_dataModel != dataModel) {
        _dataModel = dataModel;
        
        /* 段飞临时需求调整 这个判断条件暂时去掉
        //信用账户激活失败时，默认展示储蓄账户
        if (_dataModel.blankNote.creditAccountStatusEnumType.integerValue == 2) {
            
        }
         */
        
        //默认展示储蓄账户 段飞临时需求调整
        //1选中储蓄账户
        [self.segmentView resetSelectButton:QGAccountSegmentViewSelectTypeSavings];
        //2改变scollView展示的视图
        self.segmentView.selectBlock(QGAccountSegmentViewSelectTypeSavings);
        
        //设置标签
        self.segmentView.tagString = _dataModel.blankNote.costReturnCashRate;
        
        //设置账单和分期cell
        [self resetBillAndTermWithBlankNote:_dataModel.blankNote];
        
    }
    
    //设置存款账户相关
    [self.savingsView setAmount:_dataModel.blankNote.depositAmount firstDepositAd:_dataModel.blankNote.firstDepositAd depositRecordList:_dataModel.blankNote.depositRecordList];
    
}


/// 重设账单和分期显示
- (void)resetBillAndTermWithBlankNote:(QGBlankNoteModel *)blankNoteModel
{
    self.creditView.billSubCell.descLabel.text = blankNoteModel.billRepayDay;
    //设置分期期数相关
     //已经设置过分期
     ZHAttributedLabelTool * attributedDesc;
    if (blankNoteModel.indexPageRightButton.configTermHasSetTerm.boolValue) {
        //分一期的时候，显示不分期
        if (blankNoteModel.indexPageRightButton.configTermSetTerm.integerValue == 1) {
            attributedDesc = [[ZHAttributedLabelTool alloc] initWithText:@"不分期" font:[UIFont qg_lightFontOfSize:12] color:[UIColor textColor9999]];
        }
        else
        {
            NSString * configTermStr = [NSString stringWithFormat:@"分 %@ 期",blankNoteModel.indexPageRightButton.configTermSetTerm];
            attributedDesc = [[ZHAttributedLabelTool alloc] initWithText:configTermStr font:[UIFont qg_lightFontOfSize:12] color:[UIColor textColor9999]];
            [attributedDesc addFont:[UIFont qg_mediumFontOfSize:12] range:NSMakeRange(2, blankNoteModel.indexPageRightButton.configTermSetTerm.length)];
            
        }
    }
    //未设置过分期
    else
    {
        attributedDesc = [[ZHAttributedLabelTool alloc] initWithText:@"默认不分期" font:[UIFont qg_lightFontOfSize:12] color:[UIColor textColor9999]];
    }
     self.creditView.configTermSubCell.descLabel.attributedText = [attributedDesc getResultString];
}

@end
