//
//  QGCardHeaderUnActiveCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/11.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardHeaderUnActiveCell.h"

#import "QGCardGoAnimationView.h"
#import "QGGradientView.h"

@interface QGCardHeaderUnActiveCell ()


/// 激活按钮
@property (nonatomic, strong, readwrite) UIButton * activateButton;

/// go动画
@property (nonatomic, strong) QGCardGoAnimationView * goAnimationView;
@end


@implementation QGCardHeaderUnActiveCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        //开通标识
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:self.cardContentView title:@"开通享花卡" titleFontSize:[UIFont qg_lightFontOfSize:convertEqualScaleFrom375(12)] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.inset(convertEqualScaleFrom375(18));
            make.height.mas_equalTo(convertEqualScaleFrom375(17));
        }];
        
        //底部圆角层
        QGDesignatedCornerView * activeContentView = [[QGDesignatedCornerView alloc] initWithRadius:convertEqualScaleFrom375(40)/2.0 corner:UIRectCornerTopRight|UIRectCornerBottomRight];
        [self.cardContentView addSubview:activeContentView];
        [self.cardContentView insertSubview:activeContentView belowSubview:self.treeImageView];
        activeContentView.clipsToBounds = YES;
        [activeContentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(-10);
            make.bottom.inset(convertEqualScaleFrom375(13));
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(180), convertEqualScaleFrom375(40)));
        }];
        
        //渐变图层
        QGGradientView * gradientView = [[QGGradientView alloc] init];
        gradientView.gradientLayer.locations = @[@(0),@(0.75)];
        gradientView.gradientLayer.colors = @[(id)[UIColor yyMainThemeColor].CGColor,(id)[UIColor colorWithHexString:@"FFFFFF"].CGColor];
        [activeContentView addSubview:gradientView];
        [gradientView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.inset(0);
        }];
        
        //go动画
        self.goAnimationView = [[QGCardGoAnimationView alloc] init];
        [gradientView addSubview:self.goAnimationView];
        [self.goAnimationView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.top.inset(convertEqualScaleFrom375(0));
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(40), convertEqualScaleFrom375(40)));
        }];
        
        
        //免费开通字样
        UILabel * openTitleLabel = [UILabel creatLabelWithSuperView:activeContentView title:@"免费开通" titleFontSize:[UIFont qg_mediumFontOfSize:convertEqualScaleFrom375(15)] textColor:[UIColor yyMainThemeColor] alignment:NSTextAlignmentRight];
        [openTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.mas_equalTo(self.goAnimationView.mas_left).offset(convertEqualScaleFrom375(-6));
            make.centerY.offset(0);
        }];
        
        //描述
        UILabel * descLabel = [UILabel creatLabelWithSuperView:self.cardContentView title:@"• 享最高5万额度\n• 享消费返现高收益" titleFontSize:[UIFont qg_mediumFontOfSize:convertEqualScaleFrom375(16)] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        descLabel.numberOfLines = 0;
        [descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(convertEqualScaleFrom375(15));
            make.top.inset(convertEqualScaleFrom375(67));
        }];
        
        //点击按钮
        self.activateButton = [UIButton creatButtonWithSuperView:activeContentView title:nil titleFont:nil textColor:nil];
        [self.activateButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.inset(0);
        }];
    }
    return self;
}


- (void)setBlanNoteModel:(QGBlankNoteModel *)blanNoteModel
{
    [super setBlanNoteModel:blanNoteModel];
    [self.goAnimationView startAnimation];
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
