//
//  QGCardHeaderLightAnimationBaseCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/11.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardHeaderLightAnimationBaseCell.h"
#import "QGCardNormalStatusAnimationView.h"


@interface QGCardHeaderLightAnimationBaseCell ()

/// 光动画视图
@property (nonatomic, strong) QGCardNormalStatusAnimationView * lightAnimationView;
    
@end

@implementation QGCardHeaderLightAnimationBaseCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        //台子
        UIImageView * stationView = [UIImageView creatImageViewWithSuperView:self.cardContentView imageName:@"card_header_station"];
        [self.cardContentView insertSubview:stationView belowSubview:self.mountainImageView];
        [stationView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(convertEqualScaleFrom375(11));
            make.bottom.inset(convertEqualScaleFrom375(9));
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(116), convertEqualScaleFrom375(77)));
        }];
        
        //人
        UIImageView * manImageView = [UIImageView creatImageViewWithSuperView:self.cardContentView imageName:@"card_header_man"];
        [manImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.mas_equalTo(stationView.mas_right).inset(convertEqualScaleFrom375(32));
            make.bottom.mas_equalTo(stationView.mas_top).offset(convertEqualScaleFrom375(10));
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(15), convertEqualScaleFrom375(34)));
        }];
        
        //黄金
        UIImageView * glodImageView = [UIImageView creatImageViewWithSuperView:self.cardContentView imageName:@"card_header_glod"];
        [glodImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(105), convertEqualScaleFrom375(51)));
            make.centerX.mas_equalTo(stationView);
            make.bottom.mas_equalTo(stationView.mas_top).offset(convertEqualScaleFrom375(-26));
        }];
        
        //动画视图
        self.lightAnimationView = [[QGCardNormalStatusAnimationView alloc]initWithFrame:CGRectMake(MAINSCREEN_WIDTH - 40 - convertEqualScaleFrom375(150), convertEqualScaleFrom375(4), convertEqualScaleFrom375(150), convertEqualScaleFrom375(116))];
        [self.cardContentView addSubview:self.lightAnimationView];
        
        
        
        
    }
    return self;
}

- (void)setBlanNoteModel:(QGBlankNoteModel *)blanNoteModel
{
    [super setBlanNoteModel:blanNoteModel];
    //开始动画
    [self.lightAnimationView startAnimation];
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
