//
//  QGCardBaseHeaderCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/11.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardBaseHeaderCell.h"



#import "QGGradientView.h"
@interface QGCardBaseHeaderCell ()


/// 卡片区
@property (nonatomic, strong, readwrite) QGDesignatedCornerView * cardContentView;

/// 渐变层
@property (nonatomic, strong) QGGradientView * gradientView;

/// 享花卡字样
@property (nonatomic, strong) UIImageView * appNameImageView;

/// 享花卡和上银之间的分割线
@property (nonatomic, strong) UIView * segmentLineView;

/// 银行卡名称的图片
@property (nonatomic, strong) UIImageView * bankCardNameImageView;

/// 左侧的树
@property (nonatomic, strong, readwrite) UIImageView * treeImageView;

/// 山
@property (nonatomic, strong, readwrite) UIImageView * mountainImageView;

/// slogan
@property (nonatomic, strong) UIImageView * sloganImageView;

@end


@implementation QGCardBaseHeaderCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //阴影 暂时不要阴影
//        UIView * shadowView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor whiteColor]];
//        [shadowView setShadowColor:[UIColor shadowColor] shadowRadius:2 shadowOffset:CGSizeMake(0, 4) cornerRadius:10];
//        [shadowView mas_makeConstraints:^(MASConstraintMaker *make) {
//            make.left.right.inset(20);
//            make.top.inset(5);
//            make.bottom.inset(0);
//        }];
        
        //卡片底层
        self.cardContentView = [[QGDesignatedCornerView alloc] initWithRadius:10 corner:UIRectCornerAllCorners];
        [self.contentView addSubview:self.cardContentView];
        self.cardContentView.clipsToBounds = YES;
        [self.cardContentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.inset(5);
            make.bottom.inset(0);
        }];
        
        //渐变图层
        self.gradientView = [[QGGradientView alloc] init];
        self.gradientView.gradientLayer.locations = @[@(0.15),@(0.85)];
        [self.cardContentView addSubview:self.gradientView];
        [self.gradientView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.inset(0);
        }];
        
        //享花卡字样
        self.appNameImageView = [UIImageView creatImageViewWithSuperView:self.cardContentView imageName:@"card_header_app_name"];
        [self.appNameImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.inset(convertEqualScaleFrom375(13));
            make.left.inset(convertEqualScaleFrom375(15));
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(50), convertEqualScaleFrom375(16)));
        }];

        //享花卡和上银的分割线
        self.segmentLineView = [UIView creatViewWithSuperView:self.cardContentView backgroundColor:[UIColor colorWithHexString:@"FFD9B1"]];
        self.segmentLineView.hidden = YES;
        [self.segmentLineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.appNameImageView.mas_right).offset(10);
            make.centerY.mas_equalTo(self.appNameImageView).offset(-2);
            make.size.mas_equalTo(CGSizeMake(1, convertEqualScaleFrom375(18)));
        }];
        
        //上银logo
        self.bankCardNameImageView = [UIImageView creatImageViewWithSuperView:self.cardContentView imageName:@"card_header_cardname"];
        self.bankCardNameImageView.hidden = YES;
        [self.bankCardNameImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.segmentLineView.mas_right).offset(10);
            make.centerY.mas_equalTo(self.appNameImageView);
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(63), convertEqualScaleFrom375(17)));
        }];
        
        //山
        self.mountainImageView = [UIImageView creatImageViewWithSuperView:self.cardContentView imageName:@"card_header_mountain"];
        [self.mountainImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(convertEqualScaleFrom375(17));
            make.bottom.inset(0);
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(273), convertEqualScaleFrom375(23)));
        }];
        
        //树
        self.treeImageView = [UIImageView creatImageViewWithSuperView:self.cardContentView imageName:@"card_header_tree"];
        [self.treeImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(33), convertEqualScaleFrom375(31)));
            make.left.offset(convertEqualScaleFrom375(12));
            make.bottom.offset(0);
        }];
        
        //slogan
        self.sloganImageView = [UIImageView creatImageViewWithSuperView:self.cardContentView imageName:@"card_header_slogan"];
        [self.sloganImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.bottom.inset(convertEqualScaleFrom375(15));
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(88), convertEqualScaleFrom375(10)));
        }];
        
        
    }
    return self;
}



- (void)setBlanNoteModel:(QGBlankNoteModel *)blanNoteModel
{
    if (_blanNoteModel != blanNoteModel) {
        _blanNoteModel = blanNoteModel;
        
        //如果已经激活了闪付卡 则展示展示享花卡和上银标识
        if (_blanNoteModel.showCreditDesc.boolValue && _blanNoteModel.depositAccountStatusEnumType.integerValue == 1) {
            self.segmentLineView.hidden = NO;
            self.bankCardNameImageView.hidden = NO;
            self.appNameImageView.hidden = NO;
        }
        else
        {
            self.segmentLineView.hidden = YES;
            self.bankCardNameImageView.hidden = YES;
            self.appNameImageView.hidden = YES;
        }
        
    }
    
}



- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}


- (void)layoutSubviews
{
    [super layoutSubviews];
    
}


+ (CGFloat)cellHeight
{
    return 5 + convertEqualScaleFrom375(200);
}



@end
