//
//  QGCardReviewSuccessAnimationView.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/12.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardReviewSuccessAnimationView.h"
#import "QGBasicUITool.h"

@interface QGCardReviewSuccessAnimationView ()

/// 一束小光
@property (nonatomic, strong) UIImageView * smallLightImageView;

/// 一束小光动画
@property (nonatomic, strong) CAAnimationGroup * smallLightAnimationGroup;

/// 一束大光
@property (nonatomic, strong) UIImageView * bigLightImageView;

/// 一束大光动画
@property (nonatomic, strong) CAAnimationGroup * bigLightAnimationGroup;
@end

@implementation QGCardReviewSuccessAnimationView

- (CGSize)intrinsicContentSize
{
    return CGSizeMake(convertEqualScaleFrom375(215), convertEqualScaleFrom375(200));
}


- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //小束光
        self.smallLightImageView = [UIImageView creatImageViewWithSuperView:self imageName:@"card_header_small_light"];
        self.smallLightImageView.layer.anchorPoint = CGPointMake(0.5, 0);
        [self.smallLightImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(371), convertEqualScaleFrom375(188)));
            make.right.mas_equalTo(self.mas_right).offset(convertEqualScaleFrom375(371)/2.0);
            make.top.mas_equalTo(self.mas_top).offset(-convertEqualScaleFrom375(188)/2.0);
        }];
        
        //大束光
        self.bigLightImageView = [UIImageView creatImageViewWithSuperView:self imageName:@"card_header_big_light"];
        self.bigLightImageView.layer.anchorPoint = CGPointMake(1, 0.5);
        [self.bigLightImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(260), convertEqualScaleFrom375(336)));
            make.right.mas_equalTo(self.mas_right).offset(convertEqualScaleFrom375(260)/2.0);
            make.top.mas_equalTo(self.mas_top).offset(-convertEqualScaleFrom375(336)/2.0);
        }];

        [self creatSmallLightAnimationWithDuration:2];
        [self creatbigLightAnimationWithDuration:2];
        
    }
    return self;
}

///小束光动画
- (void)creatSmallLightAnimationWithDuration:(CGFloat)animationDuration
{
    ///旋转动画
    CABasicAnimation * rotationAnimation = [CABasicAnimation animationWithKeyPath:@"transform.rotation"];
    rotationAnimation.fromValue = @(65/180.0*M_PI);
    rotationAnimation.toValue = @(0);
    rotationAnimation.duration = animationDuration;
    
    //缩放动画
    CABasicAnimation * scaleAnimation = [CABasicAnimation animationWithKeyPath:@"transform.scale"];
    scaleAnimation.fromValue = @(0.4);
    scaleAnimation.toValue = @(1);
    scaleAnimation.duration = animationDuration;
    
    CAAnimationGroup * animationGroup = [CAAnimationGroup animation];
    animationGroup.animations = @[rotationAnimation,scaleAnimation];
    animationGroup.duration = animationDuration;
    self.smallLightAnimationGroup = animationGroup;
}


///大束光动画
- (void)creatbigLightAnimationWithDuration:(CGFloat)animationDuration
{
    ///旋转动画
    CABasicAnimation * rotationAnimation = [CABasicAnimation animationWithKeyPath:@"transform.rotation"];
    rotationAnimation.fromValue = @(-80/180.0*M_PI);
    rotationAnimation.toValue = @(0);
    rotationAnimation.duration = animationDuration;
    
    //缩放动画
    CABasicAnimation * scaleAnimation = [CABasicAnimation animationWithKeyPath:@"transform.scale"];
    scaleAnimation.fromValue = @(0.4);
    scaleAnimation.toValue = @(1);
    scaleAnimation.duration = animationDuration;
    
    //透明度变化
    CABasicAnimation * opacityAnimation = [CABasicAnimation animationWithKeyPath:@"opacity"];
    opacityAnimation.fromValue = @(1);
    opacityAnimation.toValue = @(0.8);
    opacityAnimation.duration = animationDuration;
    
    CAAnimationGroup * animationGroup = [CAAnimationGroup animation];
    animationGroup.animations = @[rotationAnimation,scaleAnimation,opacityAnimation];
    animationGroup.duration = animationDuration;
    self.bigLightAnimationGroup = animationGroup;
}


- (void)startAnimation
{
    [self removeAnimation];
    //添加新动画
    [self.smallLightImageView.layer addAnimation:self.smallLightAnimationGroup forKey:nil];
    [self.bigLightImageView.layer addAnimation:self.bigLightAnimationGroup forKey:nil];
}

- (void)removeAnimation
{
    //移除动画
    [self.smallLightImageView.layer removeAllAnimations];
    [self.bigLightImageView.layer removeAllAnimations];
}

///进入后台移除动画
- (void)willResignActive
{
    [self removeAnimation];
}



@end
