//
//  QGCardGoAnimationView.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/12.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardGoAnimationView.h"

#import "QGBasicUITool.h"
@interface QGCardGoAnimationView ()

/// 圆圈
@property (nonatomic, strong) UIImageView * circleImageView;

/// 圆圈动画
@property (nonatomic, strong) CAAnimationGroup * circleAnimationGroup;

/// go
@property (nonatomic, strong) UIImageView * goImageView;

/// go动画组
@property (nonatomic, strong) CAKeyframeAnimation * goAnimation;
@end

@implementation QGCardGoAnimationView


- (CGSize)intrinsicContentSize
{
    return CGSizeMake(convertEqualScaleFrom375(40), convertEqualScaleFrom375(40));
}


- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //go
        self.goImageView = [UIImageView creatImageViewWithSuperView:self imageName:@"card_header_go"];
        [self.goImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(29), convertEqualScaleFrom375(29)));
            make.centerX.offset(0);
            make.centerY.offset(2);
        }];
        
        //圆圈
        self.circleImageView = [UIImageView creatImageViewWithSuperView:self imageName:@"card_header_circle"];
        [self.circleImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(convertEqualScaleFrom375(28), convertEqualScaleFrom375(28)));
            make.center.offset(0);
        }];
        
        [self creatGoAnimationWithDuration:3.9];
        [self creatCircleAnimationWithDuration:3.9];
        
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(willResignActive) name:UIApplicationWillResignActiveNotification object:nil];
        
    }
    return self;
}

//go动画
- (void)creatGoAnimationWithDuration:(CGFloat)animationDuration
{
    //缩放动画
    CAKeyframeAnimation * scaleAnimation  = [CAKeyframeAnimation animationWithKeyPath:@"transform.scale"];
    scaleAnimation.values = @[@(1),@(1),@(0.8),@(1.4),@(0.8),@(1)];
    scaleAnimation.keyTimes = @[@(0),@(0.693),@(0.77),@(0.847),@(0.924),@(1)];
    scaleAnimation.duration = animationDuration;
    self.goAnimation = scaleAnimation;
    
}

//圆圈动画
- (void)creatCircleAnimationWithDuration:(CGFloat)animationDuration
{
    //缩放动画
    CAKeyframeAnimation * scaleAnimation  = [CAKeyframeAnimation animationWithKeyPath:@"transform.scale"];
    scaleAnimation.values = @[@(1),@(1),@(0.8),@(1.4),@(0.8),@(1)];
    scaleAnimation.keyTimes = @[@(0),@(0.693),@(0.77),@(0.847),@(0.924),@(1)];
    scaleAnimation.duration = animationDuration;
    
    //旋转动画
    CAKeyframeAnimation * rotationAnimation = [CAKeyframeAnimation animationWithKeyPath:@"transform.rotation"];
    rotationAnimation.values = @[@(0),@(0),@(2*M_PI),@(4*M_PI),@(4*M_PI),@(4*M_PI)];
    rotationAnimation.keyTimes = @[@(0),@(0.693),@(0.77),@(0.847),@(0.924),@(1)];
    rotationAnimation.duration = animationDuration;
    
    self.circleAnimationGroup = [CAAnimationGroup animation];
    self.circleAnimationGroup.animations = @[scaleAnimation,rotationAnimation];
    self.circleAnimationGroup.duration = animationDuration;    
}


- (void)startAnimation
{
    [self removeAnimation];
    //添加新动画
    [self.goImageView.layer addAnimation:self.goAnimation forKey:nil];
    [self.circleImageView.layer addAnimation:self.circleAnimationGroup forKey:nil];
}

- (void)removeAnimation
{
    //移除动画
    [self.goImageView.layer removeAllAnimations];
    [self.circleImageView.layer removeAllAnimations];
}

///进入后台移除动画
- (void)willResignActive
{
    [self removeAnimation];
}

@end
