//
//  QGBindingCardCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/18.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBindingCardCell.h"

#import "QGBasicUITool.h"
#import "QGBindingCardSubCell.h"
@interface QGBindingCardCell () <UICollectionViewDelegate, UICollectionViewDataSource>

@property (nonatomic, strong) UICollectionView * collectionView;

/// 标题
@property (nonatomic, strong) NSArray * nameArray;

/// icon展示
@property (nonatomic, strong) NSArray * iconImageView;

@end

@implementation QGBindingCardCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        //立即绑卡
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"立即绑卡" titleFontSize:[UIFont qg_mediumFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.inset(20);
            make.height.mas_equalTo(20);
        }];
        
        //collectionView
        UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc] init];
        layout.minimumLineSpacing = 10;
        layout.minimumInteritemSpacing = 0;
        layout.itemSize = CGSizeMake((MAINSCREEN_WIDTH - 20 * 2 - 10 * 2)/3.0, 90);
        layout.scrollDirection  = UICollectionViewScrollDirectionHorizontal;
        
        self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
        self.collectionView.scrollEnabled = NO;
        self.collectionView.backgroundColor = [UIColor whiteColor];
        self.collectionView.dataSource = self;
        self.collectionView.delegate = self;
        [self.contentView addSubview:self.collectionView];
        
        [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(14);
            make.height.mas_equalTo(90);
        }];
        
        [self.collectionView registerClass:[QGBindingCardSubCell class] forCellWithReuseIdentifier:NSStringFromClass([QGBindingCardSubCell class])];
        
        
        self.nameArray = @[@"微信支付",@"支付宝",@"手机钱包"];
        self.iconImageView = @[@"card_binding_wechat",@"card_binding_alipay",@"card_binding_wallet"];
        
    }
    return self;
}


- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return MIN(self.nameArray.count, self.iconImageView.count);
}

// The cell that is returned must be retrieved from a call to -dequeueReusableCellWithReuseIdentifier:forIndexPath:
- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGBindingCardSubCell * cell = (QGBindingCardSubCell *)[collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGBindingCardSubCell class]) forIndexPath:indexPath];
    
    NSString * titleStr = self.nameArray[indexPath.row];
    
    if ([titleStr isEqualToString:@"微信支付"]) {
        cell.titleLabel.backgroundColor = [UIColor colorWithHexString:@"56CD2F"];
    }
    else if ([titleStr isEqualToString:@"支付宝"])
    {
        cell.titleLabel.backgroundColor = [UIColor colorWithHexString:@"42B0F4"];
    }
    else if ([titleStr isEqualToString:@"手机钱包"])
    {
        cell.titleLabel.backgroundColor = [UIColor colorWithHexString:@"F66F56"];
    }
    
    cell.titleLabel.text = titleStr;
    cell.iconImageView.image = [UIImage imageNamed:self.iconImageView[indexPath.row]];
    
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    NSString * titleStr = self.nameArray[indexPath.row];
    if ([titleStr isEqualToString:@"微信支付"]) {
        
        if (self.openWalletBlock) {
            self.openWalletBlock(BindingCardClickTypeWechat);
        }
        
    }
    else if ([titleStr isEqualToString:@"支付宝"])
    {
        if (self.openWalletBlock) {
            self.openWalletBlock(BindingCardClickTypeAlipay);
        }
    }
    else if ([titleStr isEqualToString:@"手机钱包"])
    {
        if (self.openWalletBlock) {
            self.openWalletBlock(BindingCardClickTypeWallet);
        }

    }
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
