//
//  QGNotifyInfoModel.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/29.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGNotifyInfoModel.h"
#import "QGBasicUITool.h"
@implementation QGNotifyInfoModel

+ (NSArray *)modelPropertyBlacklist {
    return @[@"contentTool",@"contentHeight"];
}

- (CGFloat)contentHeight
{
    if (_contentHeight == 0) {
        CGFloat titleHeight = [NSString getHeightWithContent:self.title width:MAINSCREEN_WIDTH - 20 - 87 UIFont:[UIFont qg_regularFontOfSize:16]];
        CGFloat contentHeight = [self.contentTool getSizeWithMaxWidth:MAINSCREEN_WIDTH - 40].height;
        _contentHeight = 16 + titleHeight + 55 + contentHeight + 30;
        
    }
    return _contentHeight;
}

- (ZHAttributedLabelTool *)contentTool
{
    if (!_contentTool && self.content.length > 0) {
        _contentTool = [[ZHAttributedLabelTool alloc] initWithText:self.content font:[UIFont qg_lightFontOfSize:14] color:[UIColor textColor3333]];
//        [_contentTool setFirstLineHeadIndent:28];
    }
    return _contentTool;
}

@end
