//
//  QGCardHomeModel.m
//  VirtualPayment
//
//  Created by 张博 on 2019/6/19.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardHomeModel.h"
#import "NSString+CreditWallet.h"
#import "QGBasicUITool.h"
#import "ZHAttributedLabelTool.h"
#import "QGCalendarManager.h"
@implementation QGCardHomeModel

+ (NSDictionary *)modelCustomPropertyMapper {
    return @{@"blankNote" : @"indexPageMvpVo",
             @"loanBanner" : @"indexBanner",
             };
}


+ (NSDictionary *)modelContainerPropertyGenericClass {
    return @{@"loanBanner" : [QGCardBannerModel class]
    };
}

@end


@implementation QGBlankNoteModel

+ (NSArray *)modelPropertyBlacklist {
    return @[@"headerType",@"cellShowType",@"headerCardNameStr",@"quickPassCellHeight"];
}

+ (NSDictionary *)modelContainerPropertyGenericClass {
    return @{@"notifyInfoList" : [QGNotifyInfoModel class],
             @"quickEntranceList" : [QGQuickEntranceModel class],
             @"saveMoneyConfigList" : [QGSaveMoneyConfigModel class],
             @"depositRecordList" : [QGDepositRecordVoModel class]
    };
}



- (HomeCardHeaderType)headerType
{
    //激活状态要有数据
    if (_headerType < HomeCardHeaderTypeNormal && self.accountStatusEnumType.length > 0) {
  
        //账户状态：0-初始状态(未开通享花卡)，1-激活享花卡成功，2-激活享花卡失败，4-审核中，6-激活上银2类户成功 7-激活上银2类户失败
        //审核中
       if (self.accountStatusEnumType.integerValue == 4)
        {
            _headerType = HomeCardHeaderTypeInReview;
        }
        //被拒绝
        else if (self.accountStatusEnumType.integerValue == 2)
        {
            _headerType = HomeCardHeaderTypeReject;
        }
        //激活二类户失败 或者 开通享花卡成功
        else if (self.accountStatusEnumType.integerValue == 7 || self.accountStatusEnumType.integerValue == 1)
        {
            _headerType = HomeCardHeaderTypeCardUnActive;
        }
        //激活二类户成功
        else if (self.accountStatusEnumType.integerValue == 6)
        {
            _headerType = HomeCardHeaderTypeCardActiveSuccess;
        }
        else
        {
            _headerType = HomeCardHeaderTypeNormal;
        }
        
        
    }
    return _headerType;
}

- (NSAttributedString *)headerCardNameStr
{
    //展示卡片并且状态为已激活
    if (!_headerCardNameStr && self.showCreditDesc.boolValue && self.headerType == HomeCardHeaderTypeCardActiveSuccess) {
        NSString * cardName = [NSString stringWithFormat:@"%@    享花卡",self.sySecondAccountCardName];
        
        ZHAttributedLabelTool * tool = [[ZHAttributedLabelTool alloc] initWithText:cardName font:[UIFont qg_regularFontOfSize:17] color:[UIColor whiteColor]];
        [tool addAttachmentWithImageName:@"card_header_line" index:self.sySecondAccountCardName.length + 2 size:CGRectMake(0, -2, 1, 14)];
        _headerCardNameStr = [tool getResultString];
    }
    return _headerCardNameStr;
}





@end




@implementation QGCardBannerModel

+ (NSDictionary *)modelCustomPropertyMapper {
    return @{@"bannerID" : @"id"
             };
}

@end



@implementation QGCardHomeRightButton



@end

@implementation QGCardLatestTradeRecodeModel



@end

@implementation QGFirstDepositAdModel



@end

@implementation QGDepositRecordVoModel

+ (NSArray *)modelPropertyBlacklist {
    return @[@"showTimeStr"];
}

- (NSString *)showTimeStr
{
    if (_showTimeStr.length == 0 && self.tradeTime.length > 0) {
        _showTimeStr = [[QGCalendarManager shareInstance] getDateStringWithTimestamp:self.tradeTime.integerValue andFormatter:@"MM-dd HH:mm"];
    }
    return _showTimeStr;
}

@end


@implementation QGQuickEntranceModel



@end

@implementation QGSaveMoneyConfigModel



@end




