//
//  QGCardHomeModel.h
//  VirtualPayment
//
//  Created by 张博 on 2019/6/19.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"
#import "ZHAttributedLabelTool.h"
#import "QGNotifyInfoModel.h"
@class QGBlankNoteModel, QGCardBannerModel, QGCardHomeRightButton, QGCardQuickPassModel,QGCardLatestTradeRecodeModel, QGQuickEntranceModel, QGSaveMoneyConfigModel,QGDepositRecordVoModel,QGFirstDepositAdModel;
NS_ASSUME_NONNULL_BEGIN

@interface QGCardHomeModel : QGBaseModel
/**
 激活状态数据
 */
@property (nonatomic, strong) QGBlankNoteModel * blankNote;

/**
 banner数组
 */
@property (nonatomic, strong) NSArray <QGCardBannerModel *>* loanBanner;

@end



typedef NS_ENUM(NSUInteger, HomeCardHeaderType) {
    ///默认的状态
    HomeCardHeaderTypeNormal = 1,
    ///审核中
    HomeCardHeaderTypeInReview,
    ///审核拒绝
    HomeCardHeaderTypeReject,
    ///未激活二类户
    HomeCardHeaderTypeCardUnActive,
    ///激活二类户成功
    HomeCardHeaderTypeCardActiveSuccess
};


///激活状态数据
@interface QGBlankNoteModel : QGBaseModel

#pragma mark - 废弃字段
/**
 账户状态：0-初始状态(未开通享花卡)，1-激活享花卡成功，2-激活享花卡失败，4-审核中，6-激活上银2类户成功 7-激活上银2类户失败
 */
@property (nonatomic, strong) NSString * accountStatusEnumType;

#pragma mark - 废弃字段


/// 二类户账户状态 0-初始状态，1-激活成功，2-激活失败
@property (nonatomic, strong) NSString * depositAccountStatusEnumType;

/// 信用账户状态 0-初始状态，1-激活成功，2-激活失败，4-审核中
@property (nonatomic, strong) NSString * creditAccountStatusEnumType;

/**
 * 还款账单状态
 * 1: 未消费
 * 2：已消费，未出账
 * 3：已出账，待还款（1-10号展示）
 * 4：还款日后，逾期
 * 5：还款成功
 */
@property (nonatomic, strong) NSString * repayBillStatusEnumType;

/// 消费返现比率 文案：消费返1%
@property (nonatomic, strong) NSString * costReturnCashRate;

///是否有提额标识
@property (nonatomic, strong) NSString * isHasQuotaFlag;

/// 储蓄账户余额
@property (nonatomic, strong) NSString * depositAmount;

/// 账户明细跳转URL
@property (nonatomic, strong) NSString * debitRecordListUrl;

/// 二类户开通失败原因
@property (nonatomic, strong) NSString * quickPayFailedReason;

/// 最新的交易或还款记录
@property (nonatomic, strong) QGCardLatestTradeRecodeModel * latestTradeRecode;

/// 首冲广告
@property (nonatomic, strong) QGFirstDepositAdModel * firstDepositAd;

/// 消费记录，最多两条
@property (nonatomic, strong) NSArray <QGDepositRecordVoModel *> * depositRecordList;

/// 消费返现 快捷入口
@property (nonatomic, strong) NSArray <QGQuickEntranceModel *> * quickEntranceList;

/// 省钱推荐配置项
@property (nonatomic, strong) NSArray <QGSaveMoneyConfigModel *> * saveMoneyConfigList;

/// 激活标识
@property (nonatomic, strong) NSString * activeFlag;


/**
* 可用额度
* 开通二类户成功后，获取到可用额度
* 进行消费后，剩余可用额度
*/
@property (nonatomic, strong) NSString * canUseAmount;

/**
 还款日
 */
@property (nonatomic, strong) NSString * billRepayDay;

/**
 本月应还URL
 */
@property (nonatomic, strong) NSString * appRepayUrl;

/// 下月还款URL
@property (nonatomic, strong) NSString * appPreRepayUrl;

/**
 已用额度=(授信额度 - 可用额度)  优先级 1
 */
@property (nonatomic, strong) NSString * usedAmount;

/**
 本月应还
 */
@property (nonatomic, strong) NSString * repayAmount;

/// 下月还款金额
@property (nonatomic, strong) NSString * nextRepayAmount;

/// 还款标题： 未出账：11月待还（元）已出账：11月应还（元）
@property (nonatomic, strong) NSString * repayContent;

/**
* 逾期应还款金额
*/
@property (nonatomic, strong) NSString * overdueAmount;

/**
* 授信最高额度 八万
*/
@property (nonatomic, strong) NSString * creditMaxAmount;

/**
* 最低还款页面URL
*/
@property (nonatomic, strong) NSString * lowestRepayUrl;

/**
* 逾期的天数
*/
@property (nonatomic, strong) NSString * overdueDays;

/**
* 根据 userGroupEnumType 区分不同的展示button 内容
*/
@property (nonatomic, strong) QGCardHomeRightButton * indexPageRightButton;

/**
* 特定用户不展示立即绑卡
*/
@property (nonatomic, strong) NSString * showCreditDesc;

/**
* 1 激活成功：显示上海银行二类户卡号
*/
@property (nonatomic, strong) NSString * sySecondAccountCardNo;

/**
* 1 激活成功：显示上海银行二类户卡名称
*/
@property (nonatomic, strong) NSString * sySecondAccountCardName;

/// 显示上海银行卡持卡人的名字
@property (nonatomic, strong) NSString * sySecondAccountCardHolder;

/// 公告
@property (nonatomic, strong) NSArray <QGNotifyInfoModel *> * notifyInfoList;

/***********自己维护属性***********/

/**
 用户判断首页顶部cell展示类型
 */
@property (nonatomic, assign) HomeCardHeaderType headerType;


/**
 header左侧银行卡名字
 */
@property (nonatomic, strong) NSAttributedString * headerCardNameStr;


@end


/// 最新的交易或还款记录
@interface QGCardLatestTradeRecodeModel : QGBaseModel

/// 交易日期
@property (nonatomic, strong) NSString * tradeDate;

/// 交易描述或交易商品名称
@property (nonatomic, strong) NSString * tradeDesc;

/// tradeAmount
@property (nonatomic, strong) NSString * tradeAmount;

@end


/// 首冲广告
@interface QGFirstDepositAdModel : QGBaseModel

/// 图片链接
@property (nonatomic, strong) NSString * imgUrl;

/// 跳转链接
@property (nonatomic, strong) NSString * jumpUrl;

/// 标题
@property (nonatomic, strong) NSString * title;

/// 副标题
@property (nonatomic, strong) NSString * subTitle;
@end


/// 消费返现 快捷入口
@interface QGQuickEntranceModel : QGBaseModel

/// 图标
@property (nonatomic, strong) NSString * imgUrl;

/// 跳转链接
@property (nonatomic, strong) NSString * jumpUrl;

/// 名字
@property (nonatomic, strong) NSString * name;
@end


/// 转账记录
@interface QGDepositRecordVoModel : QGBaseModel

/// 转账内容
@property (nonatomic, strong) NSString * content;

/// 转账时间戳
@property (nonatomic, strong) NSString * tradeTime;

/// 展示的时间格式
@property (nonatomic, strong) NSString * showTimeStr;

@end


/// 省钱推荐配置项
@interface QGSaveMoneyConfigModel : QGBaseModel

/// 图片
@property (nonatomic, strong) NSString * imgUrl;

/// 跳转地址
@property (nonatomic, strong) NSString * jumpUrl;

/// 是否需要登录
@property (nonatomic, strong) NSString * loginFlag;

@property (nonatomic, copy) NSString *name ;

@end



///banner结构类
@interface QGCardBannerModel : QGBaseModel
/**
 图片地址
 */
@property (nonatomic, strong) NSString * imgUrl;

/**
 跳转地址
 */
@property (nonatomic, strong) NSString * navUrl;

/**
 bannerID
 */
@property (nonatomic, strong) NSString * bannerID;
@end


///中间层右侧的按钮
@interface QGCardHomeRightButton : QGBaseModel


/** *******************************************
* 可配置分期组：1： 可配置分期数，页面右侧button展示
* ********************************************
*/

/**
* 是否设置分期
*/
@property (nonatomic, strong) NSString * configTermHasSetTerm;

/**
* 设置的分期
*/
@property (nonatomic, strong) NSString * configTermSetTerm;



/** *******************************************
* 固定分期组：2： 固定分期用户不可修改
* ********************************************
*/

/**
* 系统特定的分期期数
* 约定是 12期
*/
@property (nonatomic, strong) NSString * fixedTermSetTerm;



/** *******************************************
* 最低还款组：3：最低还款用户组
* ********************************************
*/

/**
* 最低还款费率 百分比   10%
*/
@property (nonatomic, strong) NSString * lowestRepayRate;

@end








NS_ASSUME_NONNULL_END
