//
//  QGBindingWalletInfoCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/18.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBindingWalletInfoCell.h"

#import "QGBindingWalletInfoSubCell.h"
#import "QGGradientShadowButton.h"
#import "QGBasicUITool.h"
#import "QGCustomPageControl.h"
#import "QGAlertView.h"
@interface QGBindingWalletInfoCell () <UICollectionViewDelegate, UICollectionViewDataSource>

/// 内容展示
@property (nonatomic, strong) UICollectionView * collectionView;

/// 指示器
@property (nonatomic, strong) QGCustomPageControl * pageControl;
@end

@implementation QGBindingWalletInfoCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //标题
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"滑动查看添加教程" titleFontSize:[UIFont qg_mediumFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.left.inset(20);
            make.height.mas_equalTo(22);
        }];
        
        //内容展示
        UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc] init];
        layout.minimumLineSpacing = 0;
        layout.minimumInteritemSpacing = 0;
        layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
        layout.itemSize = CGSizeMake(MAINSCREEN_WIDTH, 231);
        self.collectionView = [[UICollectionView alloc]initWithFrame:CGRectZero collectionViewLayout:layout];
        self.collectionView.pagingEnabled = YES;
        self.collectionView.showsHorizontalScrollIndicator = NO;
        self.collectionView.delegate = self;
        self.collectionView.dataSource = self;
        self.collectionView.backgroundColor = [UIColor whiteColor];
        [self.contentView addSubview:self.collectionView];
        [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(0);
            make.top.mas_equalTo(titleLabel.mas_bottom);
            make.height.mas_equalTo(231);
        }];
        
        [self.collectionView registerClass:[QGBindingWalletInfoSubCell class] forCellWithReuseIdentifier:NSStringFromClass([QGBindingWalletInfoSubCell class])];
        
        //指示器
        self.pageControl = [[QGCustomPageControl alloc] init];
        self.pageControl.indictorSize = CGSizeMake(5, 5);
        self.pageControl.indictorSpace = 5;
        self.pageControl.centerX = self.contentView.width/2.0;
        self.pageControl.top = 273;
        [self.contentView addSubview:self.pageControl];
        self.pageControl.pageIndicatorTintColor = [[UIColor textColor9999] colorWithAlphaComponent:.4];
        self.pageControl.currentPageIndicatorTintColor = [UIColor textColor9999];

        
        
        
        //按钮
        QGGradientShadowButton * openButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.contentView title:@"复制卡号并打开钱包" textFont:[UIFont qg_regularFontOfSize:17]];
        [openButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.bottom.inset(24);
            make.height.mas_equalTo(40);
        }];
        
        @weakify(self);
        [openButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            // 复制文字到剪切板
            UIPasteboard * paste = [UIPasteboard generalPasteboard];
            NSString * resultText = [self.cardNum stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
            resultText = [resultText stringByReplacingOccurrencesOfString:@" " withString:@""];
            paste.string = resultText;
            paste.strings = @[resultText];
            
            NSURL *url = [NSURL URLWithString:@"shoebox://"];
            if ([[UIApplication sharedApplication] canOpenURL:url]) {
                [[UIApplication sharedApplication] openURL:url];
            }else{
                QGAlertView *alert = [[QGAlertView alloc]initWithTitle:nil message:@"未检测到该手机的Wallet，请安装后重试或手动打开" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:NULL];
                [alert showInView:nil];
            }
        }];
        
    }
    return self;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.walletModel.stepImageList.count;
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGBindingWalletInfoSubCell * cell = (QGBindingWalletInfoSubCell *)[collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGBindingWalletInfoSubCell class]) forIndexPath:indexPath];
    cell.stepModel = self.walletModel.stepImageList[indexPath.row];
    cell.indexLabel.text = [NSString stringWithFormat:@"%ld",indexPath.row + 1];
    return cell;
}

- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    self.pageControl.currentPage = ceilf(scrollView.contentOffset.x / scrollView.width);
}



- (void)setWalletModel:(QGBindingWalletModel *)walletModel
{
    if (_walletModel != walletModel) {
        _walletModel = walletModel;
        
        [self.collectionView reloadData];
        self.pageControl.numberOfPages = _walletModel.stepImageList.count;
    }
}



- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
