//
//  QGBindingWalletBankCardCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/18.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBindingWalletBankCardCell.h"

#import "QGBasicUITool.h"

@interface QGBindingWalletBankCardCell ()

/// 银行卡
@property (nonatomic, strong, readwrite) UIImageView * bankCardImageView;

/// 卡号
@property (nonatomic, strong, readwrite) QGPasteboardLabel * bankCardNumLabel;

@end

@implementation QGBindingWalletBankCardCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        //图片
        self.bankCardImageView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.bankCardImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(MAINSCREEN_WIDTH - 40, (MAINSCREEN_WIDTH - 40)/335.0 * 200));
            make.centerX.offset(0);
            make.top.offset(5);
        }];
        
        
        //银行卡标题
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"银行卡号" titleFontSize:[UIFont qg_lightFontOfSize:14] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(self.bankCardImageView.mas_bottom).offset(8);
            make.height.mas_equalTo(20);
            make.left.offset(20);
        }];
        
        
        //卡码
        self.bankCardNumLabel = [[QGPasteboardLabel alloc] init];
        self.bankCardNumLabel.font = [UIFont qg_regularFontOfSize:14];
        self.bankCardNumLabel.textColor = [UIColor textColor3333];
        [self.contentView addSubview:self.bankCardNumLabel];
        self.bankCardNumLabel.isClearWhitespace = YES;
        [self.bankCardNumLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(20);
            make.height.mas_equalTo(20);
            make.centerY.mas_equalTo(titleLabel);
        }];
        
        
        

    }
    return self;
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}


+ (CGFloat)cellHeight
{
    return 5 + (MAINSCREEN_WIDTH - 40)/335.0 * 200 + 43;
}

@end
