//
//  QGFloatsPopView.m
//  VirtualPayment
//
//  Created by silicn on 2019/12/12.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGFloatsPopView.h"
#import "QGBasicUITool.h"
#import "QGActivityPopModel.h"
#import "UIImageView+QGWebCache.h"
#import "UIViewController+CommonConfig.h"
#import "DeviceAdaptation.h"
#import "QGApplicationOpenURL.h"

#import "QGAnalyticsService.h"

@interface QGFloatsPopView () <UIGestureRecognizerDelegate>

@property (nonatomic, strong)UIImageView *floatIV;

@property (nonatomic, strong)QGActivityPopModel *popModel;

@property (nonatomic, strong)UIViewController *controller;

@end


@implementation QGFloatsPopView

- (instancetype)initWithModel:(QGActivityPopModel *)model
{
    self = [super init];
    if (self) {
        self.backgroundColor = [UIColor clearColor];
        //初始化位置
        self.size = CGSizeMake(65, 65);
        self.centerY = MAINSCREEN_HEIGHT/2.0;
        self.right = MAINSCREEN_WIDTH - 10;
        
        self.popModel = model;
        // 浮窗图片
        self.floatIV  = [UIImageView creatImageViewWithSuperView:self imageName:nil];
        [self.floatIV setImageByNomalPlaceholderWithURLString:model.img];
        [self.floatIV mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self);
        }];
        
        //添加点击手势
        UITapGestureRecognizer *tap =[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(clickContent)];
        [self addGestureRecognizer:tap];
        
        //添加滑动手势
        [self addPanGesture];
        
    }
    return self;
}

// 点击图片操作
- (void)clickContent {
   
     /// 不需要登录 || 需要登录并且已经登录
     if (self.popModel.needLogin == 0 || (self.popModel.needLogin == 1 && QGUserInfo.isLogin)) {
        if (self.popModel.jumpUrl) {
             [QGApplicationOpenURL  handleAllSupportUrl:self.popModel.jumpUrl];
        }
          /// 1 - 点击后不再显示,需要做标记
         if (self.popModel.showType == 1) {
             if (self.dismissBlock) {
                 self.dismissBlock(self.popModel);
             }
              [self removeFromSuperview];
         }
         /// 统计
         [self floatsClickAnalytics];
         
     }else{
         @weakify(self);
         [self.controller showLoginViewControllerCompletion:^{
             @strongify(self);
             if (self.popModel.jumpUrl) {
                 [QGApplicationOpenURL  handleAllSupportUrl:self.popModel.jumpUrl];
             }
             [self floatsClickAnalytics];
         }];
         /// 1 - 点击后不再显示,需要做标记
          if (self.popModel.showType == 1) {
              if (self.dismissBlock) {
                  self.dismissBlock(self.popModel);
              }
               [self removeFromSuperview];
          }
     }
}

/// 浮窗点击统计
- (void)floatsClickAnalytics
{
    QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:[self pageNameWithIndex:self.popModel.position] path:nil name:nil detail_name:@"浮窗内容点击"];
    [QGAnalyticsService analyticsTrackWithEvent:event];
}

/// 根据index获取位置String
- (NSString *)pageNameWithIndex:(NSInteger)index
{
    if (index == 1) {
        return @"浮窗-首页";
    }
    if (index == 2) {
        return @"浮窗-管理页";
    }
    if (index == 3) {
        return @"浮窗-我的";
    }
    
    return nil;
}

- (void)showInController:(UIViewController *)controller
{
    [controller.view addSubview:self];
     self.controller = controller;
     if (self.popModel.position == 1) { // 右上
         self.centerY = controller.view.height / 3.0;
     }
     else if (self.popModel.position == 2){  // 右中
         self.centerY = controller.view.height / 2.0;
     }
     else{  // 其他一律放在右下,下面的位置偏下一点
         if (self.controller && self.controller.tabBarController.tabBar.isHidden){
              self.bottom = controller.view.height - 20;
         }else{
             self.bottom = controller.view.height - 20 - [DeviceAdaptation getTabBarHeight];
         }
     }
  
}


#pragma mark - PanGesture
- (void)addPanGesture
{
    UIPanGestureRecognizer * panGesture = [[UIPanGestureRecognizer alloc] initWithTarget:self action:@selector(panGesture:)];
    panGesture.delegate = self;
    [self addGestureRecognizer:panGesture];
}


- (void)panGesture:(UIPanGestureRecognizer *)panGestureRecognizer
{
    switch (panGestureRecognizer.state) {
        case UIGestureRecognizerStateBegan:
        case UIGestureRecognizerStateChanged:
        {
            [self dragging:panGestureRecognizer];
        }
            break;
        case UIGestureRecognizerStateEnded: {
            [self dragEndAnimated:YES];
        }
            break;
        default:
            break;
    }
}


/// 拖拽进行中
- (void)dragging:(UIPanGestureRecognizer *)panGestureRecognizer {
    UIView *view = panGestureRecognizer.view;
    CGPoint translation = [panGestureRecognizer translationInView:view.superview];
    CGPoint center = CGPointMake(view.center.x + translation.x, view.center.y + translation.y);
    view.center = center;
    
    //浮窗需要在导航和tabbar之间
    if (view.top < [DeviceAdaptation getNavBarAndStatusBarHeight]) {
        view.top = [DeviceAdaptation getNavBarAndStatusBarHeight];
    }
    
    if (self.controller && self.controller.tabBarController.tabBar.isHidden) {
        if (view.bottom > self.controller.view.height)
        {
            view.bottom = self.controller.view.height;
        }
    }else{
        if (view.bottom > self.controller.view.height - [DeviceAdaptation getTabBarHeight])
        {
            view.bottom = self.controller.view.height - [DeviceAdaptation getTabBarHeight];
        }
    }
    
    //检测左右
    if (view.left <= 0) {
        view.left = 0;
    }
    else if (view.right >= MAINSCREEN_WIDTH)
    {
        view.right = MAINSCREEN_WIDTH;
    }
    
    [panGestureRecognizer setTranslation:CGPointZero inView:view.superview];
}

/// 拖拽结束 吸附效果
- (void)dragEndAnimated:(BOOL)animated
{
    [UIView animateWithDuration:animated ? 0.5 : 0 animations: ^{
        //靠左
        if (self.center.x < self.controller.view.width/2.0) {
            self.left = 10;
        }
        //靠右
        else
        {
            self.right = self.controller.view.width - 10;
        }
    } completion:nil];
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
