//
//  QGIncreaseAmountController.m
//  VirtualPayment
//
//  Created by 张博 on 2019/6/27.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGIncreaseAmountController.h"

//Tool
#import "QGApplicationOpenURL.h"
#import "QGCardRequestApi.h"
//model
#import "QGIncreaseAmountModel.h"

//View
#import "QGIncreaseAmountCollectionViewCell.h"
#import "QGIncreaseAmountHeaderView.h"
@interface QGIncreaseAmountController ()<UICollectionViewDelegate,UICollectionViewDataSource>

/**
 承载容器
 */
@property (nonatomic, strong) UICollectionView * collectionView;

/**
 数据源
 */
@property (nonatomic, strong) QGIncreaseAmountModel * dataModel;
@end

@implementation QGIncreaseAmountController

- (BOOL)checkParameters:(NSDictionary *)param {
    return YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self custemLeftDefaultBarButtonItem];
    self.title = @"提额";
    
    //注册cell
    [self.collectionView registerClass:[QGIncreaseAmountCollectionViewCell class] forCellWithReuseIdentifier:NSStringFromClass([QGIncreaseAmountCollectionViewCell class])];
    [self.collectionView registerClass:[QGIncreaseAmountHeaderView class] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:NSStringFromClass([QGIncreaseAmountHeaderView class])];


    
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    //请求接口
    [self requestCreditInfo];
}

///请求授信信息
- (void)requestCreditInfo
{
    @weakify(self);
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] GET:[QGCardRequestApi urlWithIndex:QGCardRequestServerMethodCreditInfo] parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        @strongify(self);
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.dataModel = [QGIncreaseAmountModel yy_modelWithJSON:responseObject[@"data"]];
            [self.collectionView reloadData];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSString * errorMessage = [QGBaseNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorMessage];
    }];
}


#pragma mark - UICollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.dataModel.creditInfos.count;
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    //授权cell
    QGIncreaseAmountCollectionViewCell * cell = [collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGIncreaseAmountCollectionViewCell class]) forIndexPath:indexPath];
    cell.infoModel = self.dataModel.creditInfos[indexPath.row];
    return cell;
}

#pragma mark - UICollectionViewDelegate

- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath
{
    QGIncreaseAmountHeaderView * headerCell = (QGIncreaseAmountHeaderView *)[collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:NSStringFromClass([QGIncreaseAmountHeaderView class]) forIndexPath:indexPath];
    headerCell.dataModel = self.dataModel;
    return headerCell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGCreditInfoModel * infoModel = self.dataModel.creditInfos[indexPath.row];
    //只有待完成能够进入
    if ([infoModel.creditStatus isEqualToString:@"await"]) {
        [QGApplicationOpenURL handleAllSupportUrl:infoModel.creditUrl];
        [self analyticsTrackItemClickEvent];
    }
    
    
}



- (UICollectionView *)collectionView
{
    if (!_collectionView) {
        UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc]init];
        //设置item size和间距
        layout.itemSize = CGSizeMake((MAINSCREEN_WIDTH - 12*2 - 20 * 2)/3.0 , (MAINSCREEN_WIDTH - 12*2 - 20 * 2)/3.0  * (115/104.0));
        layout.minimumInteritemSpacing = 6;
        layout.minimumLineSpacing = 15;
        layout.sectionInset = UIEdgeInsetsMake(20, 20, 20, 20);
        //header高度
        layout.headerReferenceSize = CGSizeMake(MAINSCREEN_WIDTH, 186);
        _collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
        _collectionView.backgroundColor = [UIColor whiteColor];
        _collectionView.delegate = self;
        _collectionView.dataSource = self;
        [self.view addSubview:_collectionView];
        
        [_collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.mas_offset(0);
            make.top.mas_equalTo(self.colorViewBar.mas_bottom).offset(0);
        }];
    }
    return _collectionView;
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

/**
 提额点击事件
 */
- (void)analyticsTrackItemClickEvent
{
    NSDictionary * infoDic = @{@"abse_page_name":self.title,@"abse_action_name":@"我要提额点击统计",@"abse_state_value":@"success"};
    [QGAnalyticsService analyticsTrack:@"AppBusinessStateEvent" withProperties:infoDic];
}


@end
