#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import sys

reload(sys)
sys.setdefaultencoding('utf-8')

# 头文件顶部代码
headerTopPrefix = "#import <Foundation/Foundation.h>\n\n"

# 头文件底部代码
headerBottomPrefix ="""@interface QGMediatorClassTools : NSObject
    
/**
    通过枚举
    
    @param headerType 类对应的枚举类型
    
    @return 返回枚举对应的类
*/
+ (NSString *)QGClassNameWithHeaderType:(QGHeaderType)headerType;

/**
通过枚举

@param headerType 类对应的枚举类型

@return 返回枚举对应的类
*/
NSString * ClassNameWithHeadType(QGHeaderType headerType);

@end
"""

# 源文件顶部代码
sourceFileTopPrefix = """#import "QGMediatorClassTools.h"
    
@implementation QGMediatorClassTools

/**
通过枚举

@param headerType 类对应的枚举类型

@return 返回枚举对应的类
*/
NSString * ClassNameWithHeadType(QGHeaderType headerType)
{
    return [QGMediatorClassTools QGClassNameWithHeaderType:headerType];
}

"""

# 源文件底部代码
sourceFileBottomPrefix = "\n@end"

# 待处理的头文件路径
originalPath = None

# 头文件输出路径
exportPath = None

# 头文件名称列表
headerFileNameList = []

# 获取头文件列表
def getHeaderFileList():
    sourceFile = originalPath
    if os.path.isdir(sourceFile):
        return
    
    # 判断读权限
    if os.access(sourceFile, os.R_OK) is False:
        return
    
    # 判断写权限
    if os.access(sourceFile, os.W_OK) is False:
        return
    
    # 将文件读取到内存中
    with open(sourceFile, "r") as fileHandleRead:
        lines = fileHandleRead.readlines()

    # 将带转换的头文件中的导入的头文件全全部注释掉
    resetHeaderContent(lines)

    for line in lines:
        # 如果该行数据不包含#import则认为后续内容不是头文件
        if "#import" not in line:
            continue
        
        line = line.replace(" ", "")
        line = line.replace("#import", "")
        line = line.replace("\"", "")
        line = line.replace("\r", "")
        line = line.replace("\n", "")
        line = line.replace("//", "")
        
        headerName, extension = os.path.splitext(line)
        if extension == ".h":
            print headerName
            headerFileNameList.append(headerName)

# 将带转换的头文件中的导入的头文件全部注释掉
def resetHeaderContent(contentList):
    destContentList = []
    
    for line in contentList:
        
        # 格式化代码
        line = line.strip() + "\n"
        
        if line.startswith("//") and "#import" in line:
            if "<Foundation/Foundation.h>" in line:
                pass
            else:
                line = line.replace("//", "", 1)
                print line
    
        line = line.strip() + "\n"
        
        if line.startswith("#import"):
            if "<Foundation/Foundation.h>" in line:
                pass
            else:
                line = "//" + line;
        destContentList.append(line)
            
             
    # 重新写入原始头文件
    with open(originalPath, "w") as fileHandleRead:
        lines = fileHandleRead.writelines(destContentList)


# 创建头文件
def createHeaderFile():
    # 拼接枚举类型的头部
    enumString = "typedef enum : NSUInteger {\n"
    
    # 拼接枚举值
    for headerFileName in headerFileNameList:
        appendString = "    QGHeaderType%s,\n" % headerFileName
        enumString = enumString + appendString

    # 拼接枚举类型尾部
    enumString = enumString + "} QGHeaderType;\n\n"

    # 拼接头文件内容
    headerFileContent = headerTopPrefix + enumString + headerBottomPrefix
    path = os.path.join(exportPath, "QGMediatorClassTools.h")
    with open(path, "w") as fileHandleWrite:
        fileHandleWrite.write(headerFileContent)

# 创建源文件
def createSourceFile():
    # 拼接方法名
    functionString = "+ (NSString *)QGClassNameWithHeaderType:(QGHeaderType)headerType {\n"
    
    # 拼接选择逻辑的头部
    functionString = functionString + "    switch (headerType) {\n"
    
    # 拼接选择逻辑
    for headerFileName in headerFileNameList:
        appendString = "        case QGHeaderType%s:\n" % headerFileName
        appendReturnString = "            return @\"%s\";\n" % headerFileName
        functionString = functionString + appendString + appendReturnString
    
    # 拼接选择逻辑的尾部
    functionString = functionString + "        default:\n            return nil;\n    }\n}\n"

    # 拼接源文件内容
    sourceFileContent = sourceFileTopPrefix + functionString + sourceFileBottomPrefix
    path = os.path.join(exportPath, "QGMediatorClassTools.m")
    with open(path, "w") as fileHandleWrite:
        fileHandleWrite.write(sourceFileContent)

# 变量处理
def setVar(path):
    if os.path.exists(path) is False:
        print "带转换的头文件不存在，请检查后重试！"
        sys.exit()
    
    global exportPath
    global originalPath
    
    originalPath = path
    exportPath, originalHeaderName = os.path.split(path)

    print "带转换的头文件路径：%s" % originalPath
    print "转换后的头文件路径：%s" % exportPath


if __name__ == '__main__':
    
    if len(sys.argv) < 2:
        print "亲，参数不对哦！ [./脚本名称  头文件路径]"
    else:
        setVar(sys.argv[1])
        getHeaderFileList()
        createHeaderFile()
        createSourceFile()

