//
//  QGWiFiViewController.m
//  NewDriver4iOS
//
//  Created by 贾萍 on 2017/12/18.
//Copyright © 2017年 成都运力科技有限公司. All rights reserved.
//

#import "QGWiFiViewController.h"
#import "QGWiFiView.h"
#import "QGHttpServer.h"
#import "GCDWebServer.h"
#import "QGIPHelper.h"

@interface QGWiFiViewController ()
@property (nonatomic, weak) QGWiFiView *wifiView;
@end

@implementation QGWiFiViewController

#pragma mark - life cycle

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"WiFi";
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:@"关闭" style:UIBarButtonItemStylePlain target:self action:@selector(dismiss)];
    QGWiFiView *wifiView = [[QGWiFiView alloc]initWithFrame:self.view.frame];
    self.wifiView = wifiView;
    self.view = wifiView;
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
   
    QGHttpServer *mgr = [QGHttpServer sharedQGHttpServer];
    GCDWebServer *server = mgr.webServer;
    if (server.isRunning) {
        if ([QGIPHelper deviceIPAdress] == nil) {
            [self.wifiView setAddress:@"Error, your Device is not connected to WiFi"];
            return;
        }
        NSString *ip_port = [NSString stringWithFormat:@"%@",server.serverURL];
        [self.wifiView setAddress:ip_port];
    } else {
        [self.wifiView setAddress:@"Error, Server Stopped"];
    }
}

#pragma mark - actions
- (void)dismiss {
    [self dismissViewControllerAnimated:YES completion:nil];
    if (self.dismissBlock) {
        self.dismissBlock();
    }
}
#pragma mark - public Method

#pragma mark - private Method

#pragma mark - delegate

#pragma mark - getters and setters

@end
