//
//  QGWiFiView.m
//  NewDriver4iOS
//
//  Created by 贾萍 on 2017/12/18.
//Copyright © 2017年 成都运力科技有限公司. All rights reserved.
//

#import "QGWiFiView.h"

@interface QGWiFiView ()
@property (nonatomic, strong) UIImageView *imageView;
@property (nonatomic, assign) CGSize imageSize;
@property (nonatomic, strong) UILabel *descLabel;
@property (nonatomic, strong) UIScrollView *scrollView;
@property (nonatomic, copy) NSString *urlStr;
@property (nonatomic, strong) UIButton *pasteboardBtn;
@end

@implementation QGWiFiView

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self commonInit];
    }
    return self;
}

- (NSString *)descTextWithAddress:(NSString *)address {
    return [NSString stringWithFormat:@"1. 请确保你的 iPhone 和 PC 在同一个局域网内\n\n2. 请确保你的 iPhone 在前台运行\n\n3. 在浏览器上打开以下URL:\n\n%@\n\n",address];
}

- (void)commonInit {
    self.backgroundColor = [UIColor colorWithRed:244/255.0 green:244/255.0 blue:244/255.0 alpha:1.0];
    UIScrollView *scrollView = [UIScrollView new];
    self.scrollView = scrollView;
    [self addSubview:scrollView];
    UIImage *image = [UIImage imageNamed:@"wifi.png"];
    self.imageSize = image.size;
    UIImageView *imageView = [[UIImageView alloc] initWithImage:image];
    self.imageView = imageView;
    [self.scrollView addSubview:imageView];
    UILabel *descLabel = [UILabel new];
    descLabel.font = [UIFont systemFontOfSize:15];
    descLabel.numberOfLines = 0;
    descLabel.text = [self descTextWithAddress:@"Fetching..."];
    self.descLabel = descLabel;
    [self.scrollView addSubview:descLabel];
    UIButton *copyBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [copyBtn setTitle:@"一键复制URL" forState:UIControlStateNormal];
    [copyBtn setTitleColor:[UIColor blueColor] forState:UIControlStateNormal];
    [copyBtn addTarget:self action:@selector(pasteboardBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    self.pasteboardBtn = copyBtn;
    [self.scrollView addSubview:copyBtn];
}

- (void)setAddress:(NSString *)address {
    self.urlStr = [address copy];
    self.descLabel.text = address = [self descTextWithAddress:address];
}

- (void)layoutSubviews {
    [super layoutSubviews];
    if (!self.imageSize.width || !self.imageSize.height || !self.descLabel.font) {
        return;
    }
    CGSize contentSize = self.frame.size;
    self.scrollView.frame = self.bounds;
    CGFloat imageW = contentSize.width * 0.8f;
    CGFloat display2RealFactor = imageW / self.imageSize.width;
    CGFloat imageH = self.imageSize.height * display2RealFactor;
    CGRect imageFrame = self.imageView.frame;
    imageFrame.size = CGSizeMake(imageW, imageH);
    self.imageView.frame = imageFrame;
    self.imageView.center = CGPointMake(contentSize.width * 0.5f, imageH * 0.5f + 60);
    CGSize labelSize = [self.descLabel.text boundingRectWithSize:CGSizeMake(contentSize.width - 30, CGFLOAT_MAX) options:NSStringDrawingUsesLineFragmentOrigin attributes:@{NSFontAttributeName:self.descLabel.font} context:nil].size;
    CGFloat labelW = labelSize.width;
    CGFloat labelH = labelSize.height;
    CGFloat labelX = (contentSize.width - labelW) * 0.5f;
    CGFloat labelY = CGRectGetMaxY(self.imageView.frame) + 20;
    self.descLabel.frame = CGRectMake(labelX, labelY, labelW, labelH);
    self.pasteboardBtn.center = CGPointMake(self.center.x, CGRectGetMaxY(self.descLabel.frame)+10+25);
    self.pasteboardBtn.bounds = CGRectMake(0, 0, 200, 50);
    self.scrollView.contentSize = CGSizeMake(0, CGRectGetMaxY(self.pasteboardBtn.frame) + 20);
}
#pragma mark - event
- (void)pasteboardBtnClick:(UIButton *)sender{
    UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
    pasteboard.string = self.urlStr;
    [sender setTitle:@"复制成功" forState:UIControlStateNormal];
    sender.enabled = NO;
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1.5 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        if (sender) {
            sender.enabled = YES;
            [sender setTitle:@"一键复制URL" forState:UIControlStateNormal];
        }
    });
}
@end
