//
//  QGLogManager.m
//  NewDriver4iOS
//
//  Created by 贾萍 on 2017/12/18.
//Copyright © 2017年 成都运力科技有限公司. All rights reserved.
//

#import "QGLogManager.h"
#include <assert.h>
#include <stdbool.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/sysctl.h>

@interface QGLogManager()



@end


@implementation QGLogManager

#pragma mark - public Method
+ (void)redirectNSLogToDucumentFile{
    //创建文件路径
    NSString *documentpath = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) lastObject];
    NSString *fileName = [NSString stringWithFormat:@"HCBNSLog.txt"];
    NSString *logFilePath = [documentpath stringByAppendingPathComponent:fileName];
    //删除已经存在文件
    NSFileManager *fileManager = [NSFileManager defaultManager];
    [fileManager removeItemAtPath:logFilePath error:nil];
#if (COMBILE_MODE == COMBILE_MODE_Debug)
    if (![QGLogManager isDebugger]) {
        //log写入
        freopen([logFilePath cStringUsingEncoding:NSASCIIStringEncoding], "a+", stderr);
    }
#elif COMBILE_MODE == COMBILE_MODE_Adhoc
    if (![QGLogManager isDebugger]) {
        //log写入
        freopen([logFilePath cStringUsingEncoding:NSASCIIStringEncoding], "a+", stderr);
    }
#elif COMBILE_MODE == COMBILE_MODE_Release
#endif
}

+ (BOOL)isDebugger{
    return AmIBeingDebugged();
}

+ (NSData *)fetchNSlogFileData{
    NSData *fileData =
    [NSData dataWithContentsOfFile:[self pathForFile]];
    return fileData;
}

+ (NSString *)fetchNSlogFileString{
    NSString *string = [[NSString alloc] initWithData:[self fetchNSlogFileData] encoding:NSUTF8StringEncoding];
    return string;
}
#pragma mark - private Method
+ (NSString *)pathForFile{
    NSString *documentpath = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) lastObject];
    BOOL exists = [[NSFileManager defaultManager] fileExistsAtPath:documentpath];
    if (!exists)
    {
        [[NSFileManager defaultManager]
         createDirectoryAtPath:documentpath
         withIntermediateDirectories:YES
         attributes:nil
         error:nil];
    }
    NSString *fileName = [NSString stringWithFormat:@"HCBNSLog.txt"];
    NSString *logFilePath = [documentpath stringByAppendingPathComponent:fileName];
    return logFilePath;
}

static bool AmIBeingDebugged(void)
// Returns true if the current process is being debugged (either
// running under the debugger or has a debugger attached post facto).
{
    int                 junk;
    int                 mib[4];
    struct kinfo_proc   info;
    size_t              size;
    
    // Initialize the flags so that, if sysctl fails for some bizarre
    // reason, we get a predictable result.
    
    info.kp_proc.p_flag =0;
    
    // Initialize mib, which tells sysctl the info we want, in this case
    // we're looking for information about a specific process ID.
    
    mib[0] = CTL_KERN;
    mib[1] = KERN_PROC;
    mib[2] = KERN_PROC_PID;
    mib[3] = getpid();
    
    // Call sysctl.
    
    size = sizeof(info);
    junk = sysctl(mib, sizeof(mib) /sizeof(*mib), &info, &size, NULL,0);
    assert(junk == 0);
    
    // We're being debugged if the P_TRACED flag is set.
    
    return ( (info.kp_proc.p_flag &P_TRACED) != 0 );
}
@end
