//
//  QGHttpServer.m
//  NewDriver4iOS
//
//  Created by 贾萍 on 2017/12/18.
//Copyright © 2017年 成都运力科技有限公司. All rights reserved.
//

#import "QGHttpServer.h"
#import "GCDWebServerDataResponse.h"
#import "QGLogManager.h"
#import "QGWiFiViewController.h"
#define kMinRefreshDelay 500  // In milliseconds

@interface QGHttpServer()
@property (nonatomic, copy) NSString *lastLogStr;
@property (nonatomic, strong) GCDWebServer *webServer;

@end


@implementation QGHttpServer

#pragma mark - public Method
+ (instancetype)sharedQGHttpServer{
    static dispatch_once_t onceToken;
    static QGHttpServer *httpServer;
    dispatch_once(&onceToken, ^{
        httpServer = [[QGHttpServer alloc] init];
    });
    return httpServer;
}

- (void)startServer{
    [QGLogManager redirectNSLogToDucumentFile];
    [self.webServer startWithPort:8080 bonjourName:nil];
//    __weakSelf(self);
//    dispatch_time_t delayTime = dispatch_time(DISPATCH_TIME_NOW, (int64_t)(10.0 * NSEC_PER_SEC));
//    dispatch_after(delayTime, dispatch_get_main_queue(), ^{
//        __strongSelf(weakSelf);
//        [strongSelf presentWIFIVC];
//    });
}

- (void)stopServer {
    [_webServer stop];
    _webServer = nil;
}

- (void)showHelpView {
    UIViewController *rootVC = [[UIApplication sharedApplication] keyWindow].rootViewController;
    QGWiFiViewController *vc = [[QGWiFiViewController alloc]init];
    [rootVC presentViewController:[[UINavigationController alloc] initWithRootViewController:vc] animated:YES completion:nil];
}

#pragma mark - private Method

- (GCDWebServerDataResponse *)createResponseBody :(GCDWebServerRequest* )request{
    GCDWebServerDataResponse *response = nil;
    
    NSString* path = request.path;
    NSDictionary* query = request.query;
//    path = @"/";
    //NSLog(@"path = %@,query = %@",path,query);
    NSMutableString* string;
    if ([path isEqualToString:@"/"]) {
        //手动刷新时重置上次访问记录
        [QGHttpServer sharedQGHttpServer].lastLogStr = @"";
        string = [[NSMutableString alloc] init];
        [string appendString:@"<!DOCTYPE html><html lang=\"en\">"];
        [string appendString:@"<head><meta charset=\"utf-8\"></head>"];
        [string appendFormat:@"<title>%s[%i]</title>", getprogname(), getpid()];
        [string appendString:@"<style>\
         body {\n\
         margin: 0px;\n\
         font-family: Courier, monospace;\n\
         font-size: 1.1em;\n\
         }\n\
         table {\n\
         width: 100%;\n\
         border-collapse: collapse;\n\
         }\n\
         tr {\n\
         vertical-align: top;\n\
         }\n\
         tr:nth-child(odd) {\n\
         background-color: #eeeeee;\n\
         }\n\
         td {\n\
         padding: 2px 10px;\n\
         }\n\
         #footer {\n\
         text-align: center;\n\
         margin: 20px 0px;\n\
         color: darkgray;\n\
         }\n\
         .error {\n\
         color: red;\n\
         font-weight: bold;\n\
         }\n\
         </style>"];
        [string appendFormat:@"<script type=\"text/javascript\">\n\
         var refreshDelay = %i;\n\
         var footerElement = null;\n\
         function updateTimestamp() {\n\
         var now = new Date();\n\
         footerElement.innerHTML = \"Last updated on \" + now.toLocaleDateString() + \" \" + now.toLocaleTimeString();\n\
         }\n\
         function refresh() {\n\
         var timeElement = document.getElementById(\"maxTime\");\n\
         var maxTime = timeElement.getAttribute(\"data-value\");\n\
         timeElement.parentNode.removeChild(timeElement);\n\
         \n\
         var xmlhttp = new XMLHttpRequest();\n\
         xmlhttp.onreadystatechange = function() {\n\
         if (xmlhttp.readyState == 4) {\n\
         if (xmlhttp.status == 200) {\n\
         var contentElement = document.getElementById(\"content\");\n\
         contentElement.innerHTML = contentElement.innerHTML + xmlhttp.responseText;\n\
         updateTimestamp();\n\
         setTimeout(refresh, refreshDelay);\n\
         } else {\n\
         footerElement.innerHTML = \"<span class=\\\"error\\\">Connection failed! Reload page to try again.</span>\";\n\
         }\n\
         }\n\
         }\n\
         xmlhttp.open(\"GET\", \"/log?after=\" + maxTime, true);\n\
         xmlhttp.send();\n\
         }\n\
         window.onload = function() {\n\
         footerElement = document.getElementById(\"footer\");\n\
         updateTimestamp();\n\
         setTimeout(refresh, refreshDelay);\n\
         }\n\
         </script>", kMinRefreshDelay];
        [string appendString:@"</head>"];
        [string appendString:@"<body>"];
        [string appendString:@"<table><tbody id=\"content\">"];
        [string appendString:@"<pre style=\"word-wrap: break-word; white-space: pre-wrap;\""];
        [self _appendLogRecordsToString:string afterAbsoluteTime:0.0];
        [string appendString:@"</pre>"];
        [string appendString:@"</tbody></table>"];
        [string appendString:@"<div id=\"footer\"></div>"];
        [string appendString:@"</body>"];
        [string appendString:@"</html>"];
    }
    else if ([path isEqualToString:@"/log"] && query[@"after"]) {
        string = [[NSMutableString alloc] init];
        double time = [query[@"after"] doubleValue];
        [self _appendLogRecordsToString:string afterAbsoluteTime:time];
        
    }
    else {
        string = [@" <html><body><p>无数据</p></body></html>" mutableCopy];
    }
    if (string == nil) {
        string = [@"" mutableCopy];
    }
    response = [GCDWebServerDataResponse responseWithHTML:string];
    return response;
}

- (void)_appendLogRecordsToString:(NSMutableString*)string afterAbsoluteTime:(double)time {
    __block double maxTime = time;
    //拼接剩下的信息
    NSString *logStr = [QGLogManager fetchNSlogFileString];
    NSString *newLogStr = @"";
    if (![logStr isEqualToString:[QGHttpServer sharedQGHttpServer].lastLogStr]) {
        newLogStr = [logStr substringFromIndex:[QGHttpServer sharedQGHttpServer].lastLogStr.length];
    }
    [QGHttpServer sharedQGHttpServer].lastLogStr = logStr;
    //字符串替换，将<>标签替换掉
    NSString *str = [newLogStr stringByReplacingOccurrencesOfString:@"<" withString:@"&lt;"];
    NSString *newStr = [str stringByReplacingOccurrencesOfString:@">" withString:@"&gt;"];
    const char* style = "color: dimgray;";
    [string appendString:@"<pre style=\"word-wrap: break-word; white-space: pre-wrap;\""];
    [string appendFormat:@"<tr style=\"%s\">%@</tr>", style, newStr];
    [string appendString:@"</pre>"];
    [string appendFormat:@"<tr id=\"maxTime\" data-value=\"%f\"></tr>", maxTime];

}

#pragma mark - set&get
- (GCDWebServer *)webServer {
    if (!_webServer) {
        _webServer = [[GCDWebServer alloc] init];
        __weak __typeof__(self) weakSelf = self;
        // Add a handler to respond to GET requests on any URL
        [_webServer addDefaultHandlerForMethod:@"GET"
                                  requestClass:[GCDWebServerRequest class]
                                  processBlock:^GCDWebServerResponse *(GCDWebServerRequest* request) {
                                      return [weakSelf createResponseBody:request];
                                      
                                      
                                  }];
        
        
        NSLog(@"Visit %@ in your web browser", _webServer.serverURL);
        
    }
    return _webServer;
}
@end
