#!/usr/bin/env python
# coding=utf-8

import subprocess
import os
import shutil
import filecmp

TEMPLATE_VERSION = 2

new_default_file_path = "/Applications/Xcode.app/Contents/Developer/Platforms/iPhoneOS.platform/Developer/Library/Xcode/Templates/File Templates/Source"
new_file_category_path = "/Applications/Xcode.app/Contents/Developer/Library/Xcode/Templates/File Templates/Source/Objective-C File.xctemplate"
template_file = os.path.expanduser('~')+"/.git_template/hooks/xcodetemplate"
template_version_cammand = "git config --global githooks.templateversion"

def move_template_if_need():

    if not template_version_can_move():
        remove_template_dir()
        return
        pass

    default_name = "/Cocoa Touch Class.xctemplate"
    old_default_path = template_file+default_name
    new_default_path = new_default_file_path+default_name
    move_template(old_default_path,new_default_path,True,False)

    category_name = "/CategoryNSObject"
    old_category_path = template_file+category_name
    new_category_path = new_file_category_path+category_name
    move_template(old_category_path,new_category_path,False,True)

    remove_template_dir()
    pass

def move_template(old_file_path,new_file_path,log,write_version):
    if not os.path.exists(old_file_path) or not os.path.exists(new_file_path):
        return
        pass

    if os.access(new_default_file_path,os.W_OK):
        # print "有权限,干"
        shutil.rmtree(new_file_path)
        shutil.copytree(old_file_path,new_file_path)
        if write_version:
            write_template_version()
            pass
    else:
        if log:
            print "💎💎💎我中断了你的提交,原因是:没有root权限,无法为你复制xcode模板"
            print "请在项目下执行sudo git commit -m \"test\"\n此命令会执行脚本让我们使用统一的xcode模板,执行完毕后再尝试你的提交💎💎💎"
            exit(-1)
            pass
        pass
        
    pass

def remove_template_dir():
    path = savePath()+"xcodetemplate"
    if os.path.exists(path):
        shutil.rmtree(path)
        pass

    pass

def template_version_can_move():
    #开启此功能,才移动
    if check_out_put("git config githooks.xcodetemplate", False, "YES") == "NO":
        print "未开启统一xcode模板功能,如需开启请执行git config githooks.xcodetemplate \"YES\""
        return
        pass
    print "已开启统一xcode模板功能"

    #1.文件不同,需要复制过去
    file = "/Cocoa Touch Class.xctemplate/NSObjectObjective-C/___FILEBASENAME___.h"
    xcode_file = new_default_file_path+file
    xcode_template_file = template_file+file
    
    #1.1模板没有,不复制
    if not os.path.exists(xcode_template_file):
        print "脚本未提供xcode模板文件,无需复制xcode模板"
        return False
        pass
    
    #1.2未安装xcode,不复制
    xcode_app = "/Applications/Xcode.app"
    if not os.path.exists(xcode_app):
        print "未安装xcode,不需要复制xcode模板"
        return False
        pass

    #1.3xcode文件没有,复制
    if not os.path.exists(xcode_file):
        print "你的xcode没有模板文件,正在帮你复制模板..."
        return True
        pass
        
    #2.内容不同,复制
    equale = filecmp.cmp(xcode_file,xcode_template_file)
    if not equale:
        print "你的xcode的模板和提供的模板不一致,正在帮你复制模板..."
        return True        
        pass

    #3.内容相同,看标记版本
    template_version = check_out_put(template_version_cammand, False, None)
    if not template_version or int(template_version)<TEMPLATE_VERSION:
        print "xcode模板已更新,正在帮你复制模板..."
        return True
        pass
    print "xcode模板一致,不需要复制模板"
    return False
    pass
def write_template_version():
    cammand = template_version_cammand+ ' ' +str(TEMPLATE_VERSION)
    check_out_put(cammand, True, "")
    print "xcode模板复制成功"
    pass

#项目/.git/hooks/
def savePath():
    currentPath = os.path.realpath(__file__);
    fileName = os.path.basename(__file__);
    hooksPath = currentPath.replace(fileName,"");
    return hooksPath
    pass


def check_out_put(cammand, can_raise, return_value):
    try:
        return subprocess.check_output(cammand, shell=True).strip()
        pass
    except subprocess.CalledProcessError as e:
        if can_raise:
            raise(e)
        else:
            return return_value
            pass
    pass
