#!/usr/bin/env python
# coding=utf-8

import subprocess
import os
import statistics
from util.colorlog import *

'''公开函数'''
def key_words():
    return ["review_","rbt_", "re_", "review-","rbt-", "re-"]
    pass

def log_operation_not_permitted(file_path, func_desc, cammand):
    print "\n"
    print file_path+"文件不存在,无法在非命令行中使用"+func_desc+"的功能,你需要:"
    print "复制下个命令创建软链接后再尝试提交代码"
    print "sudo bash " + hooks_path()+"bridge.sh"
    print "如果遇到提示权限不允许(Operation not permitted),说明你的mac SIP权限没有禁用,无法向/ust/bin里边添加文件去创建软链接,解决办法看下边的网址:"
    print "http://blog.csdn.net/u012165769/article/details/50477410"
    print "如果你仍然想继续此次提交,暂时不使用"+func_desc+"的功能,执行命令"+cammand+"后继续提交代码"
    print "\n"
    pass

def post_review_if_need():
    review_state = check_out_put("git config githooks.review", False, "NO")
    if review_state == "NO":
        return ""
        pass
    
    advice = " 如果你遇到自动发送review的问题,请先将问题反馈脚本开发者,然后执行此命令(git config githooks.review \"NO\")临时关闭一次此功能,最后重新push。\n"
    logblue(advice)
        
    check_cammand_can_execute()

    print "正在发送reviewboard请求..."
    result = check_out_put('rbt post -g -p',False, "")
    reset_review_state()
    
    print "发送reviewboard请求完毕;结果:\n"+result

    if not "\n" in result:
        return result
        pass

    return result[result.index("\n")+1:]
    pass


#根据提交信息检测是否需要标记review,并返回提交信息
def mark_if_need_review(commit_msg):
    for keyword in key_words():
        if commit_msg.find(keyword) == 0:
            check_out_put("git config githooks.review YES", False, "")
            statistics.add_review_count()
            return commit_msg[commit_msg.index(keyword)+len(keyword):]
            pass
        pass
    return commit_msg
    pass

#重置review的状态
def reset_review_state():
    if check_out_put('git config githooks.review', False ,"NO") == "YES":
        check_out_put('git config githooks.review \"NO\"', False, "")
        pass
    pass

'''私有函数'''
def file_path_exist(file):
    return os.path.exists(file) and os.path.isfile(file)
    pass

def check_cammand_can_execute():
    file_path = "/usr/bin/rbt"
    if not file_path_exist(file_path):
        log_operation_not_permitted(file_path, "自动发送review", "git config githooks.review \"NO\"")
        exit(-1)
        pass
    pass


'''基础方法'''
def hooks_path():
    currentPath = os.path.realpath(__file__);
    fileName = os.path.basename(__file__);
    return currentPath.replace(fileName,"");
    pass

def check_out_put(cammand, can_raise, return_value):
    try:
        return subprocess.check_output(cammand, shell=True).strip()
        pass
    except subprocess.CalledProcessError as e:
        if can_raise:
            raise(e)
        else:
            return return_value
            pass
    pass