#!/usr/bin/python
# -*- coding: UTF-8 -*-

import subprocess
import os
import reviewboard
from util.colorlog import *

def format_files():

    if check_out_put("git config githooks.clangformat", False) == "NO":
        print "你未开启自动代码格式的功能,如需开启请执行git config githooks.clangformat \"YES\""
        return
        pass

    if not clang_format_file_exist():
        print "未检测到.clang-format文件,无需开启格式化代码功能"
        return
    
    if not file_path_exist("/usr/local/bin/clang-format"):
        login = "如果你还未安装clang-format,请执行下面两个命令(第一个命令如果已经更新过就不用再执行了):\nbrew update & brew upgrade\nbrew install clang-format"
        logout = login+"\n看到在这个地址下载表示正确更新了:https://homebrew.bintray.com/bottles/clang-format-2017-06-22.high_sierra.bottle.tar.gz"
        logred("然后可以执行brew list看是否安装成功")
        logred(logout)
        exit(-1)
        pass

    file_path = "/usr/bin/clang-format"
    if not file_path_exist(file_path):
        reviewboard.log_operation_not_permitted(file_path, "自动代码格式化", "git config githooks.clangformat \"NO\"")
        exit(-1)
        pass

    print "正在格式化代码..."
    output = check_out_put("git diff-index --cached --name-only HEAD",False)
    for file in output.split("\n"):
        format_codefile(file)
        pass
    print "格式化代码完成"
    pass

def format_codefile(file):
    if len(file) == 0:
        return
        pass
    if not file_path_exist(file):
        print "不在的文件：%s" % file
        return
    suf = file.split(".")[-1]

    # if suf == "h" or suf == "m" or suf == "mm" or suf == "c":
    if suf == "h" or suf=="m":
        print "格式化:"+file
        check_out_put("clang-format -i -style=file "+file,True)
        add_cammand = "git add "+file
        check_out_put(add_cammand, True)
        pass

    pass

#send.py也用到这里
def clang_format_file_exist():
    clang_format_file = os.getcwd()+"/.clang-format"
    return file_path_exist(clang_format_file)
    pass

def file_path_exist(file):
    return os.path.exists(file) and os.path.isfile(file)
    pass

def check_out_put(cammand,can_raise):
    try:
        return subprocess.check_output(cammand, shell=True).strip()
        pass
    except subprocess.CalledProcessError as e:
        if can_raise:
            raise(e)
        else:
            return None
            pass
    pass

def hooks_path():
    currentPath = os.path.realpath(__file__);
    fileName = os.path.basename(__file__);
    return currentPath.replace(fileName,"");
    pass
