#!/usr/bin/env python
# coding=utf-8

import os
import re
import sys
import subprocess
import shutil
import executelimit
import hookshelp
from util.colorlog import *
from biplist import *

reload(sys)  
sys.setdefaultencoding('utf8')


TEMPLATE_FILE = ".git_template"+os.path.sep
CONFIG_FILE = "setup.plist"
GIT_FILE = ".git"
PRE_COMMIT_FILE = "pre-commit"

GLOBAL_clear_repo_config = False

def main():
    #检查依赖库是否安装及自动安装
    # check_dependent_balls()

    #检查用户名和密码,项目全路径是否正确配置
    project_paths = check_require_config()

    #创建模板文件夹
    template_path = create_template_dir()
    
    #开启当前文件夹下文件的可执行权限
    executelimit.open_execute_limit()

    #拷贝当前文件夹下所有文件到模板文件夹
    copy_code_files_to_template(template_path)

    #配置全局的git模板文件路径
    config_global_git()

    #所有项目执行命令
    setup_all_projects(project_paths)

    pass

def check_dependent_balls():
    print "  正在检查依赖库是否安装"

    pip_list = check_out_put("pip list --format=legacy", False, None)
    if not pip_list:
        logred("  未安装pip,请参考gitHub页面里常见问题一栏pip的安装方案来安装pip")
        exit(-1)
        pass
    if not "jira" in pip_list:
        print "  正在安装jira..."
        check_out_put("pip install jira --user", False, None)
        pass
    
    #安装后重新检测一次
    pip_list = check_out_put("pip list --format=legacy", False, None)
    result = True

    if not "jira" in pip_list:
        print "  请手动安装jira"
        result = False
        pass

    if not result:
        exit(-1)
        pass
    pass

def check_require_config():
    print "  正在检查必要的配置项"
    config_path = current_path()+CONFIG_FILE
    
    if not (os.path.exists(config_path) and os.path.isfile(config_path)):
        log = "  未知原因导致配置文件"+config_path+"不存在,请联系开发者"
        logred(log)
        exit(-1)
        pass

    if not check_file_is_plsit(config_path):
        log = "  未知原因导致配置文件"+config_path+"不是plist文件,无法读取,请联系开发者"
        logred(log)
        exit(-1)
        pass

    result = True
    
    jira_name = read_plist_for_key(config_path, "jiar_name", False, "")
    if not len(jira_name):
        logred("  未配置JIRA用户名")
        result = False
        pass

    jira_pwd = read_plist_for_key(config_path, "jira_pwd", False, "")
    if not len(jira_name):
        logred("  未配置JIRA密码")
        result = False
        pass

    check_out_put("git config --global jira.user "+jira_name, False, None)
    check_out_put("git config --global jira.pwd "+jira_pwd, False, None)

    project_paths = read_plist_for_key(config_path, "project_paths", False, None)
    if not project_paths:
        logred("  "+CONFIG_FILE+"中project_paths必须是数组")
        result = False
        pass

    no_project = True
    for project_path in project_paths:
        if not len(project_path):
            continue
            pass
        no_project = False
        if not(os.path.exists(project_path) and os.path.isdir(project_path)):
            logred("  无法检测到项目路径" + project_path + ",请检查"+CONFIG_FILE+"文件里项目路径的配置")
            result = False
            pass
        else:
            project_git_path = project_path+os.path.sep+GIT_FILE
            if not(os.path.exists(project_git_path) and os.path.isdir(project_git_path)):
                logred("  项目路径不正确" + project_path + ",必须配置到其下包含.git的目录为止")
                result = False
                pass
        pass
    if no_project:
        logred("  至少需要配置一个项目全路径")
        pass
    if not result:
        logred("请在当前目录下找到"+CONFIG_FILE+"完善上述配置项后重新执行当前命令")
        exit(-1)
        pass
    return project_paths
    pass

def create_template_dir():
    rootdir = os.environ['HOME']
    template_path = rootdir+os.path.sep+TEMPLATE_FILE
    
    if os.path.exists(template_path):
        print "  发现旧的模板路径存在,正在删除旧目录"
        shutil.rmtree(template_path)
        pass

    if not os.path.exists(template_path):
        print "  正在初始化模板目录"
        os.makedirs(template_path)
        pass
    
    return template_path

    pass

def copy_code_files_to_template(template_path):
    print "  正在复制代码到模板目录"
    new_path = template_path+"hooks"+os.path.sep
    shutil.copytree(current_path(),new_path)
    pass

def config_global_git():
    print "  正在配置全局的git初始化模板"
    check_out_put("git config --global init.templatedir ~/.git_template", True, "")
    pass

def setup_all_projects(project_paths):
    
    for project_path in project_paths:
        if not len(project_path):
            continue
            pass
        print "  正在初始化项目"+project_path
        hooks_path = project_path+os.path.sep+GIT_FILE+os.path.sep+"hooks"
        if os.path.exists(hooks_path):
            print "  发现旧hooks存在,正在删除旧目录"
            shutil.rmtree(hooks_path)
            pass
        
        os.chdir(project_path)
        setup = "git init"
        check_out_put(setup, True, None)
        if GLOBAL_clear_repo_config:
            hookshelp.clear_current_repo_config()
            pass

        success = check_setup_success(hooks_path)
        if success:
            loggreen("  "+project_path+"初始化完成")
            pass
        else:
            logred("  "+project_path+"初始化失败")
        pass
    pass

def check_setup_success(hooks_path):
    pre_commit = hooks_path+os.path.sep+PRE_COMMIT_FILE
    if os.path.exists(pre_commit) and os.path.isfile(pre_commit):
        if os.access(pre_commit,os.X_OK):
            return True
            pass
        pass

    return False
    pass

#处理参数
def deal_argv(argv):
    for i in range(1, len(argv)):
        
        if argv[i] == "-d":
            global GLOBAL_clear_repo_config
            GLOBAL_clear_repo_config = True
            pass

        if argv[i] == "-a":
            hookshelp.clear_all_config()
            pass

        if i==1 and (argv[i] == "-h" or argv[i] == "--help"):
            hookshelp.log_help(True)
            exit(0)
            pass
    pass


# 基础方法
def check_file_is_plsit(plist_path):
    try:
        plist = readPlist(plist_path)
        return True
    except (InvalidPlistException, NotBinaryPlistException), e:
        return False
    pass

# 此方法必须先验证是plist文件
def read_plist_for_key(plist_path, key, can_raise, return_value):
    plist = readPlist(plist_path)
    try:
        return plist[key]
    except(KeyError, Exception),e:
        return return_value
    pass

def current_path():
    currentPath = os.path.realpath(__file__);
    fileName = os.path.basename(__file__);
    return currentPath.replace(fileName,"");
    pass

def check_out_put(cammand, can_raise, return_value):
    try:
        return subprocess.check_output(cammand, shell=True).strip()
        pass
    except subprocess.CalledProcessError as e:
        if can_raise:
            raise(e)
        else:
            return return_value
            pass
    pass

#入口
if __name__ == '__main__':
    deal_argv(sys.argv)

    logblue("开始初始化配置...")
    
    main()
    
    logblue("恭喜你,所有初始化配置完毕👏👏👏")
    
    pass