package cn.quantgroup.dinglog.util;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiRobotSendRequest;
import com.dingtalk.api.response.OapiRobotSendResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @Describe:
 * @Created by tangfeng 2020-07-07 19:58
 */

public class DingTalkSendMsgUtil {

    static Logger log = LoggerFactory.getLogger(DingTalkSendMsgUtil.class);

    private static final String dingTalkWebHookDomain = "https://oapi.dingtalk.com/robot/send?access_token=";

    /**
     * 发送json串消息
     */
    public static boolean sendTextMsg(String content, String accessToken) {
        if (accessToken != null) {
            return sendTextMsg(content, null, accessToken, null);
        } else {
            return false;
        }
    }

    /**
     * 发异常消息
     */
    public static boolean sendExceptionMsg(Exception exception, String accessToken, String keyWords, List<String> filterPackageList) {
        try {
            String msg = exProcess(exception, filterPackageList);
            return sendTextMsg(msg, accessToken, keyWords,null,null);
        } catch (Exception e) {
            log.warn("sendTextMsg发消息异常：{}",e);
            return false;
        }
    }



    /**
     * 发消息并@ 某人
     */
    public static boolean sendTextMsgAt(String content, String mobiles, String accessToken) {

        return sendTextMsg(content, mobiles, accessToken, null);
    }

    public static boolean sendTextMsg(String content, String mobiles, String accessToken, String keyWords) {

        Assert.notNull(content, "消息内容不能为空");
        Assert.notNull(accessToken, "accessToken不能为空");
        if (StringUtils.isNotEmpty(keyWords)) {
            content = keyWords.concat(content);
        }
        try {
            OapiRobotSendRequest.Text text = new OapiRobotSendRequest.Text();
            text.setContent(content);
            String tokenURL = dingTalkWebHookDomain.concat(accessToken);
            DingTalkClient client = new DefaultDingTalkClient(tokenURL);
            OapiRobotSendRequest request = new OapiRobotSendRequest();
            request.setMsgtype("text");
            request.setText(text);

            if (StringUtils.isNotEmpty(mobiles)) {
                OapiRobotSendRequest.At at = new OapiRobotSendRequest.At();
                at.setAtMobiles(Arrays.asList(mobiles.split(",")));
                // isAtAll类型如果不为Boolean，请升级至最新SDK
                at.setIsAtAll(true);
                request.setAt(at);
            }

            OapiRobotSendResponse response = client.execute(request);
            //System.out.println(JSONObject.toJSONString(response));
        } catch (Exception e) {
            log.warn("DingTalkSendMsgUtil.sendTextMsg发消息异常：{}",e);
        }
        return true;
    }

    /**
     * 发消息并@某人
     */
    public static boolean sendTextMsg(String content, String accessToken, String keyWords,List<String> filterPackageList,String mobiles) {

        Assert.notNull(content, "消息内容不能为空");
        Assert.notNull(accessToken, "accessToken不能为空");
        if (StringUtils.isNotEmpty(keyWords)) {
            content = keyWords.concat(content);
        }

        //信息长度，钉钉最多支持20000
        if (content.length() > 19000) {
            content = content.substring(0, 19000);
        }
        try {
            OapiRobotSendRequest.Text text = new OapiRobotSendRequest.Text();
            text.setContent(content);
            String tokenURL = dingTalkWebHookDomain.concat(accessToken);
            DingTalkClient client = new DefaultDingTalkClient(tokenURL);
            OapiRobotSendRequest request = new OapiRobotSendRequest();
            request.setMsgtype("text");
            request.setText(text);

            if (StringUtils.isNotEmpty(mobiles)) {
                OapiRobotSendRequest.At at = new OapiRobotSendRequest.At();
                at.setAtMobiles(Arrays.asList(mobiles.split(",")));
                // isAtAll类型如果不为Boolean，请升级至最新SDK
                at.setIsAtAll(true);
                request.setAt(at);
            }
            OapiRobotSendResponse response = client.execute(request);
            return true;
        } catch (Exception e) {
            log.warn("DingTalkSendMsgUtil.sendTextMsg发消息异常：{}",e);
        }
        return false;
    }

    /**
     * 异常信息处理成文本
     */
    private static String exProcess(Exception exception,List<String> filterPackageList){

        StackTraceElement[] stackTrace = exception.getStackTrace();
        String exMessage = exception.getMessage();
        exMessage = StringUtils.isEmpty(exMessage)?"":exMessage;
        String typeName = exception.getClass().getTypeName();

        StringBuffer sbExMsg = new StringBuffer();
        sbExMsg.append(": ").append(typeName).append("-").append(exMessage).append("\n");

        if (stackTrace!= null && stackTrace.length>0) {
            for (int i = 0; i < stackTrace.length; i++) {
                StackTraceElement st = stackTrace[i];
                if (StringUtils.isNotEmpty(stackTrace.getClass().toString())) {
                    if (!CollectionUtils.isEmpty(filterPackageList) && contains(st.toString(),filterPackageList)) {
                        sbExMsg.append(st.toString()).append("\n");
                        continue;
                    }
                    if (CollectionUtils.isEmpty(filterPackageList)) {
                        sbExMsg.append(st.toString()).append("\n");
                    }
                    continue;
                }
            }
            exMessage = exMessage.concat(", ").concat(sbExMsg.toString());
        }
        return exMessage;
    }
    
    private static boolean contains(String str,List<String> containsList){
        if (StringUtils.isEmpty(str) && CollectionUtils.isEmpty(containsList)) {
            return true;
        }
        if (StringUtils.isNotEmpty(str) && !CollectionUtils.isEmpty(containsList)) {
            for (String s : containsList) {
                if (str.contains(s)) {
                    return true;
                }
            }
        }
        return false;
    }
}
