package cn.quantgroup.dinglog.util;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiRobotSendRequest;
import com.dingtalk.api.response.OapiRobotSendResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

import java.util.Arrays;

/**
 * @Describe:
 * @Created by tangfeng 2020-07-07 19:58
 */

public class DingTalkSendMsgUtil {

    private static final String dingTalkWebHookDomain = "https://oapi.dingtalk.com/robot/send?access_token=";

    /**
     * 发送json串消息
     */
    public static boolean sendTextMsg(String content, String accessToken) {

        return sendTextMsg(content,null, accessToken, null);
    }

    public static boolean sendTextMsgAt(String content,String mobiles, String accessToken) {

        return sendTextMsg(content,mobiles, accessToken, null);
    }

    public static boolean sendTextMsg(String content, String mobiles, String accessToken, String keyWords) {

        Assert.notNull(content, "消息内容不能为空");
        Assert.notNull(accessToken, "accessToken不能为空");
        if (StringUtils.isNotEmpty(keyWords)) {
            content = keyWords.concat(content);
        }
        try {
            OapiRobotSendRequest.Text text = new OapiRobotSendRequest.Text();
            text.setContent(content);
            String tokenURL = dingTalkWebHookDomain.concat(accessToken);
            DingTalkClient client = new DefaultDingTalkClient(tokenURL);
            OapiRobotSendRequest request = new OapiRobotSendRequest();
            request.setMsgtype("text");
            request.setText(text);

            if (StringUtils.isNotEmpty(mobiles)){
                OapiRobotSendRequest.At at = new OapiRobotSendRequest.At();
                at.setAtMobiles(Arrays.asList(mobiles.split(",")));
                // isAtAll类型如果不为Boolean，请升级至最新SDK
                at.setIsAtAll(true);
                request.setAt(at);
            }

            OapiRobotSendResponse response = client.execute(request);
            //System.out.println(JSONObject.toJSONString(response));
        } catch (Exception e) {
            System.out.println("========");
        }
        return true;
    }
}
