package cn.quantgroup.dinglog.util;


import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import cn.quantgroup.dinglog.config.DingTalkHookLogErrorConfig;
import com.alibaba.fastjson.JSON;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.HttpResponseData;
import com.taobao.api.internal.util.WebV2Utils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @Describe:
 * @Created by tangfeng 2020-07-07 19:58
 */
public class LogErrorSendMsgUtil {

    static Logger logger =  LoggerFactory.getLogger(LogErrorSendMsgUtil.class);



   static ThreadPoolExecutor executor =
            new ThreadPoolExecutor(1,1,5l, TimeUnit.MINUTES,new ArrayBlockingQueue<>(200),
                    new ThreadFactory(){
                    public Thread newThread(Runnable r) {
                        return new Thread(r, "钉钉log错误消息");
                    }},new ThreadPoolExecutor.DiscardOldestPolicy());

    public static void sendMsg(String msg,Throwable e){

        if(msg==null) {
            return ;
        }
        if(!DingTalkHookLogErrorConfig.isEnable()){
            return;
        }
        if(e!=null){
            msg = msg +"\n"+getStackTraceElementMessage(e);
        }
        sendMsg(msg);
    }

    public static  String getStackTraceElementMessage(Throwable ex){
        int index = 0;
        String errorMessage = "";
        StackTraceElement[] stackTraceElements = ex.getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append(ex.fillInStackTrace()+"  ");
        for(StackTraceElement stackTraceElement:stackTraceElements){
            if(index >3){
                return errorMessage;
            }
            String className = stackTraceElement.getClassName();
            if(className.contains("quantgroup") || className.contains(".qg.")||
                    className.contains(".xyqb.")||className.contains(".lkb.")||
                    className.contains(".liangkebang.") ){
                index ++;
                sb.append(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":"
                        + stackTraceElement.getLineNumber() + ")   ");
                errorMessage = sb.toString();
            }
        }
        return errorMessage;
    }



    public static void sendMsg(String msg){
        if(!DingTalkHookLogErrorConfig.isEnable()){
            return;
        }
        executor.execute(()->{
            //组装参数,准备发送
//           long time = LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            String error_time  = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());

            Map<String,String> params = new LinkedHashMap<>();
            params.put("error_time",error_time );
            String project_name = System.getProperty("@appId");
            if(project_name == null){
                project_name =  System.getProperty("sun.java.command");
                String[] strings = project_name.split("\\.");
                project_name = strings[strings.length-1];
            }
            params.put("project_name",project_name);
            params.put("env",System.getProperty("env"));
            params.put("msg",msg);
            HttpResponseData responseData = null;
            logger.debug("发送错误信息 url={}, json={}",DingTalkHookLogErrorConfig.getUrl(),JSON.toJSONString(params));
            try {
                //不关心返回结果
                responseData = WebV2Utils.doPost(DingTalkHookLogErrorConfig.getUrl(), params, Constants.CHARSET_UTF8,
                        1000, 1000);
            } catch (IOException e) {
                e.printStackTrace();
            }
            if(responseData.getBody()!=null&&responseData.getBody().contains("ok")){
                logger.info("项目名{},环境={},发送成功",project_name,System.getProperty("env"));
            }else{
                logger.info("项目名{},环境={}, 发送失败",project_name,System.getProperty("env"));
            }

        });
    }


    public static void main(String[] args) {
        String s = "cn.quantgroup.kdsp.operation.KdspOperationApplication";
        String[] strings = s.split("\\.");
        System.out.println(strings[2]);
    }

}
