// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import store from './store'
// import VueRouter from 'vue-router'
import router from '@/router'
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-default/index.css'
import './css/common.css'
import './css/iconfont.css'

// import routes from './config/routes'
import App from './App'
import splitting from './modules/code-splitting-demo'


// Vue.use(VueRouter) //路由注册
Vue.use(ElementUI) //UI框架注册

// const router = new VueRouter({
//   routes
// })

const whiteList = ['/login'] // 不重定向白名单

router.beforeEach(({meta, path}, from, next) => {
  console.log("begin")
  if (whiteList.indexOf(path) !== -1) {
    next()
  } else {
    store.dispatch('GenerateRoutes')
    let {auth = true} = meta
    let isLogin = Boolean(store.state.login.tokens != '') //true用户已登录， false用户未登录

    if (auth && !isLogin && path !== '/login') {
      return next({path: '/login'})
    }

    if (isLogin && (path == '/login' || path == '/')) { //已登录过，则跳转到主页
      // store.dispatch('GetInfo')
      return next({path: '/home/channels'})
    }

    next()
  }

})

//mock.start() //启动ajax mock服务

// splitting.start() //demo：运行webpack2 code splitting示例

new Vue({
  el: '#app',
  router,
  store,
  render: h => h(App)
});
