import request from '../utils/request'

export function getChannels(data) {
    return request({
        url: '/channel/page',
        method: 'post',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded'
        },
        params: data
    })
}

export function getStaticElement() {
    return request({
        url: '/channel/static/element',
        method: 'get'
    })
}

export function getChannelDetail(query) {
    return request({
        url: '/channel/get/info',
        method: 'get',
        params: query
    })
}

export function saveChannelBaseConf(data) {
    return request({
        url: '/channel/update/baseConf',
        method: 'post',
        data
    })
}



export function saveApplyCheckConf(data) {
    return request({
        url: '/channel/saveApplyCheckConf',
        method: 'post',
        data
    })
}


export function saveApplyPrivilegeConf(data) {
    return request({
        url: '/channel/saveApplyPrivilegeConf',
        method: 'post',
        data
    })
}

export function saveCallbackConf(data) {
    return request({
        url: '/channel/saveCallbackConf',
        method: 'post',
        data
    })
}

export function saveRsaConf(data) {
    return request({
        url: '/channel/saveRsaConf',
        method: 'post',
        data
    })
}

export function refreshCache() {
    return request({
        url: '/channel/refreshCache',
        method: 'get'
    })
}
