import Vue from 'vue'
import Router from 'vue-router'

// in development-env not use lazy-loading, because lazy-loading too many pages will cause webpack hot update too slow. so only in production use lazy-loading;
// detail: https://panjiachen.github.io/vue-element-admin-site/#/lazy-loading

Vue.use(Router)

/* Layout */
import Layout from '@/modules/layout/Layout'

/**
* hidden: true                   if `hidden:true` will not show in the sidebar(default is false)
* alwaysShow: true               if set true, will always show the root menu, whatever its child routes length
*                                if not set alwaysShow, only more than one route under the children
*                                it will becomes nested mode, otherwise not show the root menu
* redirect: noredirect           if `redirect:noredirect` will no redirect in the breadcrumb
* name:'router-name'             the name is used by <keep-alive> (must set!!!)
* meta : {
    title: 'title'               the name show in subMenu and breadcrumb (recommend set)
    icon: 'svg-name'             the icon show in the sidebar
    breadcrumb: false            if false, the item will hidden in breadcrumb(default is true)
  }
**/

export const constantRouterMap = [
  { path: '/login', component: () => import('@/modules/login/index'), hidden: true },
  { path: '/404', component: () => import('@/modules/404'), hidden: true },

  {
    path: '',
    redirect: '/channel',
    component: Layout,
    children: [
      {
        path: 'channel',
        name: 'Channel',
        component: () => import('@/modules/channel/index'),
        meta: { title: '配置', icon: 'form' }
      }
    ]
  },

  {
    path: '/report',
    component: Layout,
    children: [
      {
        path: '',
        name: 'Report',
        component: () => import('@/modules/report/index'),
        meta: { title: '订单', icon: 'nested' }
      }
    ]
  },

  // {
  //   path: '/testorder',
  //   component: Layout,
  //   meta: {
  //     title: '测试订单',
  //     icon: 'people'
  //   },
  //   children: [
  //     {
  //       path: 'generate',
  //       name: 'generate',
  //       component: () => import('@/views/testorder/generate'),
  //       meta: { title: '生成订单' }
  //     },
  //     {
  //       path: 'query',
  //       name: 'query',
  //       component: () => import('@/views/testorder/query'),
  //       meta: { title: '查询订单' }
  //     }
  //   ]
  // },

  {
    path: '/',
    name: 'Dashboard',
    component: Layout,
    hidden: true,
    children: [{
      path: 'dashboard',
      component: () => import('@/modules/dashboard/index')
    }]
  },

  { path: '*', redirect: '/404', hidden: true }
]

export default new Router({
  mode: 'history', // 后端支持可开
  scrollBehavior: () => ({ y: 0 }),
  routes: constantRouterMap
})

export const asyncRouterMap = [
  {
    path: '/metabase',
    component: Layout,
    meta: {
      title: 'metabase',
      icon: 'user'
    },
    children: [
      {
        path: 'op',
        name: 'op',
        component: () => import('@/modules/metabase/index'),
        meta: { title: 'metabase' }
      }
    ]
  }
]
