
## Build Setup

```
依赖环境：运行项目前请确认本地已安装nodejs和npm。依赖的版本如下：
- "node": ">= 4.0.0"
- "npm": ">= 3.0.0"

※ 开发和运行时阶段依赖的其他包请到package.json中查看
```

``` bash
# 安装依赖-国内用户推荐使用npm淘宝镜像，设置方法：
# step1.npm config set registry https://registry.npm.taobao.org 
# step2.npm info underscore 
npm install

# serve with hot reload at localhost:8080
npm run dev

# build for production with minification
npm run build

# build for production and view the bundle analyzer report
npm run build --report

# run unit tests
npm run unit

# run e2e tests
npm run e2e

# run all tests
npm test
```


## 工程目录结构
```
src：项目源码。开发的时候代码写在这里。
 |--assets # 项目静态资源，编译时不进行处理的资源都放这里
 |--components # 项目公共组件库
 |--config # 公共配置文件，例如路由配置等
 |--css # 项目公共样式库
 |--modules # 项目应用模块，根据应用需要，还可以有子模块，各子模块目录结构和顶级子模块类似
 |    |--components # 模块级公共组件
 |    |--views # 模块视图
 |    |--css # 模块样式
 |    |--js # 模块脚本
 |--App.vue # 项目根视图
 |--main.js # 项目入口文件
 |--store # 基于vuex的状态管理模块
 |    |--index.js # 入口及store初始化
 |    |--mutation-types.js # mutation名称定义
 |    |--state.js # 根state
 |    |--mutations.js # 根mutation
 |    |--getters.js # 根getter
 |    |--actions.js # 根action
 |    |--modules # 子模块的store对象
 |    |    |--menu.js # menu模块
 |--apis # 服务层ajax请求服务
 |    |--mock # api数据mock服务
 |--utils # 公共库函数
 |    |--request.js # 网络请求服务，实现了对fetch的二次封装（目前只封装了get,post；实际项目中可按着示例封装其他请求）

 ```

 

 
