import Cookies from 'js-cookie'

import {SESSION_ID_KEY} from '../store/mutation-types'

export function getToken() {
  return Cookies.get(SESSION_ID_KEY)
}

export function setToken(token) {
  return Cookies.set(SESSION_ID_KEY, token, { expires: 1, path: '' })
}

export function removeToken() {
  return Cookies.remove(SESSION_ID_KEY)
}
