import request from '../utils/request'

export function getChannels(data) {
  return request({
    url: '/channel/page',
    method: 'post',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    },
    params: data
  })
}

export function getStaticElement() {
  return request({
    url: '/channel/static/element',
    method: 'get'
  })
}

export function saveChannelBaseConf(data) {
  return request({
    url: '/channel/update/baseConf',
    method: 'post',
    data
  })
}

export function getChannelDetail(query) {
  return request({
    url: '/channel/get/info',
    method: 'get',
    params: query
  })
}
