package ${modelPackage};

import ${enumsPackage}.${prefix}CreditResultEnum;
import ${callbackPackage}.${prefix}RepaymentMethodTermLabel;
import lombok.Data;
import cn.quantgroup.cashloanflow.model.standard.response.credit.CreditStatusEnum;
import cn.quantgroup.cashloanflow.model.standard.response.credit.QueryCreditStatusResponseModel;
import cn.quantgroup.cashloanflow.util.DateUtil;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
/**
* 查询授信结果入参
*
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
@Data
public class ${prefix}QueryCreditApplyResult {

    private ${prefix}CreditResultEnum creditResult;
    /**
    * 授信总金额(元)
    */
    private BigDecimal creditAmount;
    /**
    * 授信剩余可用额度(元)
    */
    private BigDecimal creditAvailable;
    /**
    * 分期规则,还款方式分期(REPAYMENT_METHOD)
    */
    private String termLabelsRule;

    private List<${prefix}RepaymentMethodTermLabel> repaymentMethodTermLabels;
    /**
    * 授信额度失效日期如:"2020-03-05"
    */
    private String creditExpireDate;
    /**
    * 用户授信情况描述，若”授信拒绝“则显示拒绝原因
    */
    private String creditInfo;
    /**
    * 下次申请时间（如yyyy-MM-dd）,如果额度申请结果为拒绝需要提供
    */
    private String nextApplyTime;


    public static ${prefix}QueryCreditApplyResult getSuccessResult(QueryCreditStatusResponseModel info) {
        ${prefix}QueryCreditApplyResult result = new ${prefix}QueryCreditApplyResult();
        return result;
    }

}