package cn.quantgroup.codegenerator.util;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

/**
 * @author Wang Xiangwei
 * @version 2020/6/1
 */
public class XmlParseUtil {


    public static Map<String, String> parseXml() throws Exception {


        Map<String,String> node = new HashMap<>();

        File xmlFile = new File(System.getProperty("user.dir"), "/src/main/resources/GenerateConf.xml");
        File projectFile = new File(System.getProperty("user.dir"));
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document doc = builder.parse(xmlFile);



        Element rootElement = doc.getDocumentElement(); //获取根元素
        Node author = rootElement.getElementsByTagName("author").item(0);
        String authorValue = author.getFirstChild().getNodeValue();
        node.put("author",authorValue);

        Node prefix = rootElement.getElementsByTagName("prefix").item(0);
        String prefixValue = prefix.getFirstChild().getNodeValue();
        node.put("prefix",prefixValue);

        StringJoiner modelPathJoiner = new StringJoiner(File.separator);
        modelPathJoiner.add(projectFile.getParent())
            .add(prefixValue.toLowerCase())
            .add("dto")
            .add("model");


        String modelPath = modelPathJoiner.toString();
        String modelPackage = "cn.quantgroup.clf.api."+prefixValue.toLowerCase()+".dto.model";

        node.put("modelPath",modelPath);
        node.put("modelPackage",modelPackage);



        StringJoiner utilPathJoiner = new StringJoiner(File.separator);
        utilPathJoiner.add(projectFile.getParent())
                .add(prefixValue.toLowerCase())
                .add("dto")
                .add("util");
        String utilPath = utilPathJoiner.toString();
        String utilPackage = "cn.quantgroup.clf.api."+prefixValue.toLowerCase()+".dto.util";

        node.put("utilPath",utilPath);
        node.put("utilPackage",utilPackage);


        StringJoiner enumsPathJoiner = new StringJoiner(File.separator);
        enumsPathJoiner.add(projectFile.getParent())
                .add(prefixValue.toLowerCase())
                .add("dto")
                .add("enums");
        String enumsPath = enumsPathJoiner.toString();
        String enumsPackage = "cn.quantgroup.clf.api."+prefixValue.toLowerCase()+".dto.enums";

        node.put("enumsPath",enumsPath);
        node.put("enumsPackage",enumsPackage);


        StringJoiner callbackPathJoiner = new StringJoiner(File.separator);
        callbackPathJoiner.add(projectFile.getParent())
                .add(prefixValue.toLowerCase())
                .add("dto")
                .add("callback");
        String callbackPath = callbackPathJoiner.toString();
        String callbackPackage =  "cn.quantgroup.clf.api."+prefixValue.toLowerCase()+".dto.callback";

        node.put("callbackPath",callbackPath);
        node.put("callbackPackage",callbackPackage);


        StringJoiner servicePathJoiner = new StringJoiner(File.separator);
        servicePathJoiner.add(projectFile.getParent())
                .add(prefixValue.toLowerCase())
                .add("service");
        String servicePath = servicePathJoiner.toString();
        String servicePackage = "cn.quantgroup.clf.api."+prefixValue.toLowerCase()+".service";

        node.put("servicePath",servicePath);
        node.put("servicePackage",servicePackage);

//        Node eventHandler = rootElement.getElementsByTagName("eventHandler").item(0);
//        String eventHandlerPath = ((Element) eventHandler).getAttribute("path");
//        String eventHandlerPackage = ((Element) eventHandler).getElementsByTagName("packageName").item(0).getFirstChild().getNodeValue();
        StringJoiner eventHandlerPathJoiner = new StringJoiner(File.separator);
        eventHandlerPathJoiner.add(projectFile.getParent())
                .add(prefixValue.toLowerCase())
                .add("eventhandler");
        String eventHandlerPath = eventHandlerPathJoiner.toString();
        String eventHandlerPackage = "cn.quantgroup.clf.api."+prefixValue.toLowerCase()+".dto.eventhandler";
        node.put("eventhandlerPath",eventHandlerPath);
        node.put("eventhandlerPackage",eventHandlerPackage);

        return node;
    }

    public static void main(String[] args) {
        try {
            Map<String, String> stringStringMap = XmlParseUtil.parseXml();
            System.out.println(stringStringMap);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
