package ${utilPackage};

import cn.quantgroup.loanflow.infrastructure.code.ApplicationServiceCode;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
public enum ${prefix}CodeEnum implements ApplicationServiceCode {
    SUCCESS("100000", "成功"),
    ERROR("200000", "异常"),
    SIGN_ERROR("200001", "加签失败"),
    VERIFY_SIGN_ERROR("200002", "验签失败"),
    DECRYPT_ERROR("200003", "解密失败"),
    ENCRYPTION_ERROR("200004", "加密失败"),
    TIME_OUT_ERROR("200005", "系统超时"),
    SYSTEM_ERROR("200006", "系统异常"),
    PARAM_ERROR("200007", "无效的请求参数"),
    AGREEMENT_NULL("200900", "查询没有数据"),


    // 准入
    USER_ACCESS_NO("200100", "准入失败"),
    USER_REPEAT("200101", "重复用户"),

    // 联合注册
    USER_REGISTER_ERROR("200200", "注册失败(非准入失败导致)"),
    USER_REGISTER_ACCESS_ERROR("200201", "注册失败(准入失败导致)"),

    //绑卡
    BIND_PHONE_ERROR("200300", "预留手机号错误"),
    BIND_IDNO_ERROR("200301", "身份证验证失败"),
    BIND_BANKCARDNO_ERROR("200302", "银行卡已绑定"),
    BIND_OVERDUE_ERROR("200303", "验证码过期"),
    BIND_NAME_ERROR("301204", "实名认证不通过"),
    BIND_NAME_AND_ID_ERROR("301205", "姓名身份证号码不一致"),
    BIND_BANKCARDNO_PHONE_ERROR("301206", "银行卡预留手机不一致"),
    BIND_BANKCARDNO_SUPPORT_ERROR("301207", "银行卡不支持"),
    BIND_SEND_FREQUENTLY_ERROR("301208", "发送短信过于频繁"),


    // 提现

    ;

    @Getter
    private String code;
    @Getter
    private String msg;

    ${prefix}CodeEnum(String value, String msg) {
        this.code = value;
        this.msg = msg;
    }

    /**
    * 预审
    * REVIEW_USER_ERROR("0100", "复申用户"),
    * BLACKLIST_USER_ERROR("0200", "黑名单用户"),
    * EXIST_LOAN_USER_ERROR("0300", "在贷用户，不允许进件"),
    * OVERDUE_ERROR("0400", "逾期记录"),
    * REFUSE_ERROR("0500", "30天内拒绝"),
    * EXIST_LOANING_ERROR("0600", "存在申请订单"),
    * AGE_ERROR("0701", "年龄不符合要求"),
    * NOT_WITHDRAW_ERROR("0702", "审核已通过未提现"),
    * BLACKLIST_USERS_ERROR("0703", "黑名单用户"),
    *
    * @param code
    * @return
    */
    public static ApplicationServiceCode getUserAccessCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return USER_ACCESS_NO;
        }
        switch (code) {
            case "0300":
                return USER_REPEAT;
            case "0100":
            case "0200":
            case "0400":
            case "0500":
            case "0600":
            case "0701":
            case "0702":
            case "0703":
                return USER_ACCESS_NO;
            default:
                return USER_ACCESS_NO;
        }
    }

    /**
    * 绑卡
    *
    * @param code
    * @return
    */
    public static ApplicationServiceCode getBindSmsCode(String code) {
        if (StringUtils.isEmpty(code)) {
        return ERROR;
        }
        switch (code) {
            case "0010":
                return ERROR;
            case "0011":
                return ERROR;
            case "0100":
                return ERROR;
            case "0101":
                return BIND_BANKCARDNO_SUPPORT_ERROR;
            case "0102":
                return BIND_PHONE_ERROR;
            case "0103":
                return ERROR;
            default:
                return ERROR;
        }
    }

    /**
    * 验卡
    *
    * @param code
    * @return
    */
    public static ApplicationServiceCode getVerifySmsCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return ERROR;
        }
        switch (code) {
            case "0101":
                return ERROR;
            case "0010":
                return BIND_OVERDUE_ERROR;
            default:
                return ERROR;
        }
    }

    /**
    * 提现
    * 200500
    * 借款金额超限
    * <p>
    * 200501
    * 当日放款总额超限
    * <p>
    * 200502
    * 贷款期数不支持
    * <p>
    * 200503
    * 额度审批未通过
    *
    * @param code
    * @return
    */
    public static ApplicationServiceCode getApplyWithdraw(String code) {
        switch (code) {
            case "0003":
            case "1001":
                return ERROR;
            case "0004":
                return ERROR;
            case "0101":
                return ERROR;
            case "0200":
                return ERROR;
            default:
                return ERROR;
        }
    }


    /**
    * 如果 code == ERROR("200000", "异常"), 则取内部系统具体的错误信息
    *
    * @param code 根据内部系统返回的code转换成金山的code
    * @param msg  内部系统详细的msg
    * @return 返回给金山的msg
    */
    public static String getReturnMsg(ApplicationServiceCode code, String msg) {
        if (${prefix}CodeEnum.ERROR.equals(code)) {
            return msg;
        }
            return code.getMsg();
        }
    }
