package ${servicePackage};


import ${modelPackage}.${prefix}CreditApplyRequest;
import ${modelPackage}.${prefix}QueryCreditApplyResult;
import ${modelPackage}.${prefix}UserAccessRequest;
import ${modelPackage}.${prefix}QueryCreditApplyRequest;
import ${modelPackage}.${prefix}QuerySupportBankcardsRequest;
import ${modelPackage}.${prefix}QueryLoanTrialRequest;
import ${modelPackage}.${prefix}UserAccessResult;
import ${modelPackage}.${prefix}BindBankCardSmsRequest;
import ${modelPackage}.${prefix}CreditApplyResult;
import ${modelPackage}.${prefix}VerifyBindSmsRequest;
import ${modelPackage}.${prefix}ApplyLoanRequest;
import ${modelPackage}.${prefix}QueryLoanRequest;
import ${modelPackage}.${prefix}RepayByPlanRequest;
import ${modelPackage}.${prefix}QueryRepayRequest;
import ${modelPackage}.${prefix}CreditApplyRequest;
import ${enumsPackage}.${prefix}SignStatusEnum;
import ${enumsPackage}.${prefix}UserAccessResultEnum;
import ${utilPackage}.${prefix}ResultUtils;
import ${utilPackage}.${prefix}CodeEnum;
import cn.quantgroup.cashloanflow.entity.cashloanflow.LoanMapping;
import cn.quantgroup.cashloanflow.entity.cashloanflow.LoanOrderMapping;
import cn.quantgroup.cashloanflow.model.standard.apply.ApplyLoanCheckData;
import cn.quantgroup.cashloanflow.model.standard.response.credit.QueryCreditStatusResponseModel;
import cn.quantgroup.cashloanflow.model.xyqb.BusinessType;
import cn.quantgroup.cashloanflow.model.xyqb.orderstatus.OrderStatusEnums;
import cn.quantgroup.cashloanflow.repository.cashloanflow.ILoanOrderMappingRepository;
import cn.quantgroup.cashloanflow.service.cashloanflow.IChannelApplyInfoStrategyService;
import cn.quantgroup.cashloanflow.service.cashloanflow.ILoanOrderMappingService;
import cn.quantgroup.cashloanflow.service.cashloanflow.LoanMappingService;
import cn.quantgroup.cashloanflow.util.DateUtil;
import cn.quantgroup.cashloanflow.util.IpUtil;
import cn.quantgroup.cashloanflow.util.JsonUtil;
import cn.quantgroup.cashloanflow.util.loan.ProductUtil;
import cn.quantgroup.clf.api.jinshan.util.JinShanUtil;

import cn.quantgroup.clf.applyloancheck.CheckResponse;
import cn.quantgroup.loanflow.application.StandardApplicationService;
import cn.quantgroup.loanflow.application.model.ApplyLoanData;
import cn.quantgroup.loanflow.infrastructure.code.UserCode;
import cn.quantgroup.loanflow.infrastructure.result.ServiceResult;
import cn.quantgroup.loanflow.order.model.BindCardConfirm;
import cn.quantgroup.loanflow.order.model.BindCardVerifyInfo;
import cn.quantgroup.loanflow.order.model.ChannelOrder;
import cn.quantgroup.loanflow.order.model.OrderStatus;
import cn.quantgroup.loanflow.order.model.command.BindCardCommand;
import cn.quantgroup.loanflow.order.model.command.BindCardVerifyCommand;
import cn.quantgroup.loanflow.order.model.command.WithDrawCommand;
import cn.quantgroup.loanflow.order.service.OrderRepresentationService;
import cn.quantgroup.loanflow.repay.model.RepaymentPlanItem;
import cn.quantgroup.loanflow.repay.model.command.NormalRepayCommand;
import cn.quantgroup.loanflow.repay.model.representation.OrderRepaymentRepresentation;
import cn.quantgroup.loanflow.repay.model.representation.QueryNormalRepayRepresentation;
import cn.quantgroup.loanflow.repay.model.representation.RepayResultRepresentation;
import cn.quantgroup.loanflow.repay.model.representation.TrialRepaymentRepresentation;
import cn.quantgroup.loanflow.risk.model.PretrialAuditQuery;
import cn.quantgroup.loanflow.risk.model.representation.PretrialAuditRepresentation;
import cn.quantgroup.loanflow.user.model.command.UserAddrImportCommand;
import cn.quantgroup.loanflow.user.model.command.UserBasicInfoImportCommand;
import cn.quantgroup.loanflow.user.model.command.UserContactImportCommand;
import cn.quantgroup.loanflow.user.model.command.UserExtInfoImportCommand;
import cn.quantgroup.loanflow.user.model.representation.SysUser;
import cn.quantgroup.loanflow.user.model.representation.SysUserDetail;
import cn.quantgroup.loanflow.user.service.UserDomainService;
import cn.quantgroup.mo.infrastructure.constants.RequestSourceEnum;
import cn.quantgroup.mo.order.model.WithdrawResult;
import cn.quantgroup.mo.order.model.output.MoBankCardInfoOutput;
import cn.quantgroup.mo.order.model.output.MoSimpleBank;
import cn.quantgroup.mo.order.service.MoOrderRepresentationService;
import cn.quantgroup.mo.risk.model.MoCreditOrder;
import cn.quantgroup.mo.risk.model.command.MoCreateCreditInfoCommand;
import cn.quantgroup.mo.risk.model.command.MoCreditConfirmInfoCommand;
import cn.quantgroup.mo.risk.model.command.MoImportRiskDataCommand;
import cn.quantgroup.mo.risk.service.MoRiskDomainService;
import cn.quantgroup.loanflow.asynctask.constant.AsyncTaskConstant;
import cn.quantgroup.loanflow.asynctask.executor.config.BizAppId;
import cn.quantgroup.loanflow.asynctask.model.ApplyLoanParam;
import cn.quantgroup.loanflow.asynctask.model.AsyncTask;
import cn.quantgroup.loanflow.asynctask.sender.DelaySender;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import cn.quantgroup.loanflow.application.apply.IAsyncApplyService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
@Service
@Slf4j
public class ${prefix}ServiceImpl implements ${prefix}Service,IAsyncApplyService{

    private static final String LOG_PRE = "[${prefix}ServiceImpl]";

    @Resource(name = "standardApplicationMoService")
    private StandardApplicationService standardApplicationService;

    @Autowired
    private MoOrderRepresentationService moOrderRepresentationService;
    @Autowired
    private HttpServletRequest httpServletRequest;
    @Autowired
    private LoanMappingService loanMappingService;
    @Autowired
    private ILoanOrderMappingService loanOrderMappingService;
    @Autowired
    @Qualifier("rabbitDelaySenderImpl")
    private DelaySender delaySender;
    @Value("1,30000,60000")
    private String scheduleStr;

    /**
    * 预审
    *
    * @param userAccessRequest
    * @return
    */
    public String userAccess(${prefix}UserAccessRequest userAccessRequest){
        String logPre = LOG_PRE + "[userAccess][${prefix}预审]";
        log.info("{} userAccessRequest={}",logPre,userAccessRequest);
        PretrialAuditQuery query = new PretrialAuditQuery();
        query.setChannelId(userAccessRequest.getChannelId());
        query.setPhoneNo(userAccessRequest.getPhoneMD5());
        query.setIdCard(userAccessRequest.getIdNoMD5());
        ServiceResult<PretrialAuditRepresentation> serviceResult = standardApplicationService.queryPretrialAudit(query);
        if (!serviceResult.isSuccess()) {
            log.error("{},错误{}", logPre, serviceResult.getMessage());

            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.getUserAccessCode(serviceResult.getCode().getCode())).toString();
        }

        ${prefix}UserAccessResult result = new ${prefix}UserAccessResult();
        if (serviceResult.getData().getAuditResult()) {
            result.setAccessResult(${prefix}UserAccessResultEnum.CONTINUE.name());
        } else {
            result.setAccessResult(${prefix}UserAccessResultEnum.BREAK.name());
        }
        return ${prefix}ResultUtils.success(result).toString();
    }

    /**
    * 提交授信
    *
    * @param request
    * @return
    */
    public String creditApply(${prefix}CreditApplyRequest request){
        String logPre = LOG_PRE +"[creditApply][授信申请]";
        log.info("{} request={}",logPre,request);
        ApplyLoanData applyLoanData = ${prefix}CreditApplyRequest.getApplyLoanData(request);
        ServiceResult<ApplyLoanRequestData> serviceResult = standardApplicationService.applyLoan(applyLoanData);
        if (!serviceResult.isSuccess()) {
            log.error("{},进件失败，result={}", logPre, serviceResult);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(), serviceResult.getMessage()).toString();
        }
        ${prefix}CreditApplyResult result = new ${prefix}CreditApplyResult(serviceResult.getData().getApplyNo());
        return ${prefix}ResultUtils.success(result).toString();
    }




    /**
    * 授信申请结果主动查询
    *
    * @param request
    * @return
    */
    public String queryCreditApply(${prefix}QueryCreditApplyRequest request){
        String logPre = LOG_PRE + "[queryCreditApply][${prefix}查询授信结果]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        String channelOrderNo = request.getChannelOrderNo();
        ServiceResult<LoanOrderMapping> orderMappingServiceResult = moOrderRepresentationService.queryChannelOrderByOrderNoAndChannelId(channelOrderNo, channelId);
        if (!orderMappingServiceResult.isSuccess() || Objects.isNull(orderMappingServiceResult.getData())) {
            log.error("{}查询授信订单失败, result={}, request={}", logPre, orderMappingServiceResult, request);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(),orderMappingServiceResult.getMessage()).toString();
        }
        LoanOrderMapping orderMapping = orderMappingServiceResult.getData();
        ${prefix}QueryCreditApplyResult result = new ${prefix}QueryCreditApplyResult();
        ServiceResult<OrderStatus> orderStatusServiceResult = standardApplicationService.queryOrderStatus(orderMapping.getChannelOrderNo(), null, channelId, null);
        if (!orderStatusServiceResult.isSuccess()) {
            log.error("{}，查询订单状态错误., serviceResult={}, channelOrderNo={}", logPre, orderStatusServiceResult, orderMapping.getChannelOrderNo());
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(),orderStatusServiceResult.getMessage()).toString();
        }
        OrderStatus orderStatus = orderStatusServiceResult.getData();
        OrderStatusEnums orderStatusEnums = orderStatusServiceResult.getData().getStatus();
        Long updateTime = orderStatus.getUpdateTime();
        if (JinShanUtil.finalStatus(orderStatusEnums)) {
        // 放款失败、关单、结清的订单返回授信已失效
            result.setCreditResult(${prefix}CreditResultEnum.CREDIT_INVALID);
            result.setCreditExpireDate(DateUtil.format(updateTime, DateUtil.YYYY_MM_DD));
            return ${prefix}ResultUtils.success(result).toString();
        }
        if (OrderStatusEnums.APPROVE_ING.equals(orderStatusEnums) || OrderStatusEnums.CREDIT_ORDER_SUBMITTING.equals(orderStatusEnums)) {
            result.setCreditResult(${prefix}CreditResultEnum.CREDIT_APPROVAL);
            return ${prefix}ResultUtils.success(result).toString();
        }
        if (OrderStatusEnums.REJECT.equals(orderStatusEnums)) {
            result.setCreditResult(${prefix}CreditResultEnum.REFUSE);
            result.setNextApplyTime(DateUtil.format(updateTime * 1000 + JinShanUtil.LIMIT_EXPIRE_DAY * DateUtil.ONE_DAY_MILLISECONDS, DateUtil.YYYY_MM_DD));
            result.setCreditInfo("授信拒绝");
            return ${prefix}ResultUtils.success(result).toString();
        }
        String productId = ProductUtil.getProductId(channelId);
        ChannelOrder channelOrderQueryCreditStatus = ChannelOrder.builder()
                                                                    .channelOrderNo(channelOrderNo)
                                                                    .channelId(channelId)
                                                                    .build();
        ServiceResult<QueryCreditStatusResponseModel> creditStatus = standardApplicationService.queryCreditStatus(channelOrderQueryCreditStatus);
        if (!creditStatus.isSuccess()) {
            log.error("{}查询失败，serviceResult={}, userId={}, productId={}", logPre, creditStatus, orderMapping.getQgUserId(), productId);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(),creditStatus.getMessage()).toString();
        }
        result = ${prefix}QueryCreditApplyResult.getSuccessResult(creditStatus.getData());
        return ${prefix}ResultUtils.success(result).toString();
    }


    /**
    * 查询支持的银行列表
    *
    * @param request
    * @return
    */
    public String querySupportBankcards(${prefix}QuerySupportBankcardsRequest request){
        String logPre = LOG_PRE + "[querySupportBankcards][${prefix}查询支持的银行列表]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        ChannelOrder channelOrder = ChannelOrder.builder()
            .channelId(channelId)
            .channelOrderNo(request.getChannelOrderNo())
            .build();
        ServiceResult<List<MoSimpleBank>> serviceResult = standardApplicationService.querySupportBank(channelOrder);
        if (!serviceResult.isSuccess()) {
            log.error("{},查询失败，result={} param={}", logPre, serviceResult,channelOrder);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(),serviceResult.getMessage()).toString();
        }
        ${prefix}QuerySupportBankcardsResult result = ${prefix}QuerySupportBankcardsResult.getSuccessResult(serviceResult.getData());
        return ${prefix}ResultUtils.success(result).toString();
    }

    /**
    * 借款试算
    *
    * @param request
    * @return
    */
    public String queryLoanTrial(${prefix}QueryLoanTrialRequest request){
        String logPre = LOG_PRE + "[queryLoanTrial][${prefix}查询试算数据]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        ChannelOrder channelOrder = ChannelOrder.builder()
            .channelOrderNo(request.getChannelOrderNo())
            .channelId(channelId)
            .build();
        ServiceResult<TrialRepaymentRepresentation> serviceResult = standardApplicationService.trialRepayment(channelOrder, request.getLoanAmount(), request.getLoanTerm());
        if (!serviceResult.isSuccess()) {
            log.error("{}失败，serviceResult={}，request={}", logPre, serviceResult, request);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(),serviceResult.getMessage()).toString();
        }
        ${prefix}QueryLoanTrialResult result = ${prefix}QueryLoanTrialResult.getCoverResult(serviceResult.getData());
        return ${prefix}ResultUtils.success(result).toString();
    }


    /**
    * 绑卡发验证码
    *
    * @param request
    * @return
    */
    public String bindBankCardSms(${prefix}BindBankCardSmsRequest request){
        String logPre = LOG_PRE + "[bindBankCardSms][${prefix}绑卡发短信]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        BindCardCommand command = new BindCardCommand();
        command.setBankCode(request.getBankCode());
        command.setReservePhoneNumber(request.getPhone());
        command.setBankCardNumber(request.getBankCardNo());
        ServiceResult<BindCardVerifyInfo> serviceResult = standardApplicationService.bindCard(channelId, request.getChannelOrderNo(), command);
        if (!serviceResult.isSuccess()) {
            log.error("{}错误，serviceResult={}, request={}", logPre, serviceResult, request);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(), serviceResult.getMessage()).toString();
        }
        ${prefix}BindBankCardSmsResult result = new ${prefix}BindBankCardSmsResult(serviceResult.getData().getVerificationId());
        return ${prefix}ResultUtils.success(result).toString();
    }

    /**
    * 验卡
    *
    * @param request
    * @return
    */
    public String verifyBindSms(${prefix}VerifyBindSmsRequest request){
        String logPre = LOG_PRE + "[verifyBindSms][${prefix}验卡]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        BindCardVerifyCommand command = new BindCardVerifyCommand();
        command.setVerificationId(request.getVerifyId());
        command.setVerificationCode(request.getSmsCode());
        ServiceResult<BindCardConfirm> serviceResult = standardApplicationService.bindCardVerify(channelId, request.getChannelOrderNo(), command);
        ${prefix}VerifyBindSmsResult result = new ${prefix}VerifyBindSmsResult();
        if (!serviceResult.isSuccess()) {
            log.error("{},错误, serviceResult={}, request={}", logPre, serviceResult, request);
            result.setSignStatus(${prefix}SignStatusEnum.FAIL);
            return  ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(), serviceResult.getMessage(), result).toString();
        }

        result.setSignStatus(${prefix}SignStatusEnum.SUCCESS);
        result.setBindId(serviceResult.getData().getBankCardId());
        return ${prefix}ResultUtils.success(result).toString();
    }


    /**
    * 申请提现
    *
    * @param request
    * @return
    */
    public String applyWithdraw(${prefix}ApplyLoanRequest request){
        String logPre = LOG_PRE + "[applyWithdraw][${prefix}申请提现]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        ServiceResult<MoBankCardInfoOutput> bankInfoResult = moOrderRepresentationService.queryBankCardInfoByBindCardId(request.getBindId());
        if (!bankInfoResult.isSuccess()) {
            log.error("{},错误，bankInfoResult={} bindId={}", logPre, bankInfoResult,request.getBindId());
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(), "根据bindId未查询到银行卡信息").toString();
        }
        MoBankCardInfoOutput bankCardInfoOutput = bankInfoResult.getData();
        WithDrawCommand command = new WithDrawCommand();
        command.setLoanPurpose(${prefix}LoanPurposesEnum.getKoaLaPurpose(request.getLoanPurpose()));
        command.setBankCardNumber(bankCardInfoOutput.getCardNo());
        ChannelOrder order = ChannelOrder.builder()
                .channelId(channelId)
                .channelOrderNo(request.getChannelOrderNo())
                .build();
        ServiceResult<WithdrawResult> serviceResult = standardApplicationService.withdraw(order, command);
        if (!serviceResult.isSuccess()) {
            log.error("{},申请提现失败，serviceResult={}， request={}", logPre, serviceResult, command);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(),serviceResult.getMessage()).toString();
        }
        ${prefix}ApplyLoanResult result = new ${prefix}ApplyLoanResult();
        result.setLoanNo(serviceResult.getData().getLoanId());
        return ${prefix}ResultUtils.success(result).toString();

    }


    /**
    * 查询还款结果
    *
    * @param request
    * @return
    */
    public String queryRepayResult(${prefix}QueryRepayRequest request){
        String logPre = LOG_PRE + "[queryRepayResult][${prefix}查询还款结果]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        ChannelOrder channelOrder = ChannelOrder.builder()
            .channelId(channelId)
            .build();
        ServiceResult<QueryNormalRepayRepresentation> serviceResult = standardApplicationService.normalRepayResultQuery(channelOrder, request.getBusinessFlowNo());
        if (!serviceResult.isSuccess()) {
            log.error("{},失败，serviceResult={}， request={}", logPre, serviceResult, request);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(),serviceResult.getMessage()).toString();
        }
        QueryNormalRepayRepresentation repayResult = serviceResult.getData();
        Long loanId = Long.valueOf(repayResult.getLoanId());
        // 查询借据信息
        LoanMapping loanMapping = loanMappingService.findByLoanIdAndChannelId(loanId, channelId);
        if (Objects.isNull(loanMapping)) {
            log.error("{}通过loanId查询LoanMapping为空, loanId={}, channelId={}", logPre, loanId, channelId);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(), "通过loanId查询LoanMapping为空").toString();
        }
        String channelLoanNo = loanMapping.getChannelLoanNo();
        // 查询还款计划
        ServiceResult<OrderRepaymentRepresentation> repaymentServiceResult = standardApplicationService.repaymentPlanQueryByCycleQuota(loanId);
        if (!repaymentServiceResult.isSuccess()) {
            log.error("{},查询还款计划返回错误或无数据,loanId={}", logPre, loanId);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(),repaymentServiceResult.getMessage()).toString();
        }
        List<RepaymentPlanItem> repaymentPlans = repaymentServiceResult.getData().getRepaymentPlans();
        ${prefix}QueryRepayResult result = ${prefix}QueryRepayResult.getSuccessResult(channelLoanNo, repayResult, repaymentPlans);
        return ${prefix}ResultUtils.success(result).toString();
    }


    /**
    * 主动还款
    *
    * @param request
    * @return
    */
    public String repayByPlan(${prefix}RepayByPlanRequest request){
        String logPre = LOG_PRE + "[repayByPlan][{prefix}发起主动还款]";
        log.info("{} request={}",logPre,request);
        Long channelId = request.getChannelId();
        ServiceResult<MoBankCardInfoOutput> bankInfoResult = moOrderRepresentationService.queryBankCardInfoByBindCardId(request.getBindId());
        if (!bankInfoResult.isSuccess()) {
            log.error("{},错误，bankInfoResult={}", logPre, bankInfoResult);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(), bankInfoResult.getMessage()).toString();
        }
        MoBankCardInfoOutput bankCardInfoOutput = bankInfoResult.getData();

        ChannelOrder channelOrder = ChannelOrder.builder()
            .channelId(channelId)
            .channelLoanNo(request.getChannelLoanNo())
            .build();
        String remoteIP = IpUtil.getRemoteIP(httpServletRequest);
        final NormalRepayCommand command = NormalRepayCommand.builder()
            .payBusinessFlowNo(request.getBusinessFlowNo())
            .termNo(Long.valueOf(request.getTermNo()))
            .repayAmount(new BigDecimal(request.getRepayAmount()))
            .bankCardNumber(bankCardInfoOutput.getCardNo())
            .clientIp(remoteIP)
            .build();
        ServiceResult<RepayResultRepresentation> serviceResult = standardApplicationService.normalRepayByCycleQuota(channelOrder, command);
        if (!serviceResult.isSuccess()) {
            log.error("{},失败, serviceResult={}, channelOrder={}, NormalRepayCommand={}", logPre, serviceResult, channelOrder, command);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(), serviceResult.getMessage()).toString();
        }
        ${prefix}RepayByPlanResult result = new ${prefix}RepayByPlanResult(serviceResult.getData().getRepaymentNo());
        return ${prefix}ResultUtils.success(result).toString();
    }



    /**
    * 借款结果查询
    *
    * @param request
    * @return
    */
    public String queryLoanResult(${prefix}QueryLoanRequest request){
        String logPre = LOG_PRE + "[queryLoanResult][${prefix}查询借款结果]";
        log.info("{} request={}",logPre,request);
        Long channelId =request.getChannelId();
        String channelLoanNo = request.getChannelLoanNo();
        LoanMapping loanMapping = loanMappingService.findByChannelLoanNoAndChannelId(channelLoanNo, channelId);
        if (Objects.isNull(loanMapping)) {
            log.error("{},查询借款订单为空，channelLoan={}", logPre, channelLoanNo);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(), "参数错误").toString();
        }
        LoanOrderMapping orderMapping = loanOrderMappingService.findById(loanMapping.getOrderMappingId());
        if (Objects.isNull(orderMapping)) {
            log.error("{}查询授信订单失败, result为空, request={}", logPre, request);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(), "参数错误").toString();
        }
        ServiceResult<OrderStatus> serviceResult = standardApplicationService.queryOrderStatus(orderMapping.getChannelOrderNo(), channelLoanNo, channelId, null);
        if (!serviceResult.isSuccess()) {
            log.error("{}查询订单状态失败, result={}, request={}", logPre, serviceResult, request);
            return ${prefix}ResultUtils.fail(${prefix}CodeEnum.ERROR.getCode(), "参数错误").toString();
        }

        return ${prefix}ResultUtils.success(serviceResult.getData()).toString();
    }


    @Override
    public ApplyLoanData getApplyLoanData(Object taskBody) {
        ${prefix}CreditApplyRequest request = (${prefix}CreditApplyRequest) taskBody;
        return ${prefix}CreditApplyRequest.getApplyLoanData(request);
    }

    @Override
    public void failCallBack(Object taskBody) {

    }

    @Override
    public StandardApplicationService getStandardApplicationService() {
        return standardApplicationService;
    }
}