package ${modelPackage};

import cn.quantgroup.cashloanflow.model.LoanDemandPurposeEnum;
import cn.quantgroup.cashloanflow.model.standard.apply.StandardApplyLoanData;
import cn.quantgroup.cashloanflow.model.standard.apply.StandardpicModelTypeEnum;
import cn.quantgroup.cashloanflow.util.RegisterFrom;
import cn.quantgroup.cashloanflow.util.Utils;


import cn.quantgroup.loanflow.risk.model.RiskInfo;
import cn.quantgroup.loanflow.risk.model.StandardOcrData;
import cn.quantgroup.loanflow.user.model.representation.SysUserContact;
import cn.quantgroup.loanflow.user.model.representation.SysUserDetail;
import cn.quantgroup.mo.infrastructure.constants.RiskLiveTypeEnum;
import cn.quantgroup.user.enums.*;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
* 通用进件入参
*
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/

@Data
public class ${prefix}CreditApplyRequest {

    /**
    * 渠道请求时间 默认当前时间
    */
    private Date applyTime = new Date();
    /**
    * 渠道
    */
    private RegisterFrom registerFrom;

    /**
    * user section
    */

    /**
    * 姓名
    */
    private String userName;
    /**
    * 手机号
    */
    private String phoneNo;
    /**
    * 身份证
    */
    private String idNo;
    /**
    * 渠道userId
    */
    private String channelUserId;
    /**
    * qq
    */
    private String qq;
    /**
    * email
    */
    private String email;

    /**
    * user ext info section
    */

    /**
    * 收入方式
    */
    private IncomeEnum incomeEnum;
    /**
    * 收入范围
    */
    private IncomeRangeEnum incomeRangeEnum;
    /**
    * 职业
    */
    private OccupationEnum occupationEnum;
    /**
    * 教育学历
    */
    private EducationEnum educationEnum;
    /**
    * 是否有车
    */
    private Boolean hasCar;
    /**
    * 是否有社保
    */
    private Boolean hasSocialSecurity;
    /**
    * 是否有房
    */
    private Boolean hasHouse;
    /**
    * 是否有信用卡
    */
    private Boolean hasCreditCard;
    /**
    * 婚姻状态
    */
    private MaritalStatus marryStatus;
    /**
    * 联系人
    */
    private List<SysUserContact> contacts;

    /**
    * 地址 省市区
    */
    private String addressLocation;
    /**
    * 省市区之后的详细地址
    */
    private String addrDetail;

    /**
    * 带有省市区+省市区之后的详细地址 全部详情地址
    */
    private String singleAllAddress;
    /**
    * 区code码，2018年
    */
    private String districtCode;

    /**
    * order section
    */

    /**
    * 渠道申请订单号
    */
    private String channelOrderNo;
    /**
    * 渠道提现单号，多订单产品需要关注
    */
    private String channelPaymentNo;

    /**
    * 渠道申请金额
    */
    private String loanAmount;
    /**
    * 借款期限
    */
    private Integer loanTerm;
    /**
    * 期限类型(1: 按天; 2: 按月; 3: 按年;) 默认按月
    */
    private Integer termType = 2;
    /**
    * 借款意愿
    */
    private LoanDemandPurposeEnum purposeEnum;
    /**
    * 订单扩展信息
    **/
    private Map<String, Object> orderExtData;
    /**
    * risk info section
    * 这部分数据透传 to spiderCenter
    */
    /**
    * 风控数据
    **/
    private RiskInfo riskInfo;





    public ${prefix}CreditApplyRequest() {
    }

    /**
    * 标准API 转换
    *
    * @param registerFrom
    * @param data
    */
    public static  ApplyLoanData getApplyLoanData(${prefix}CreditApplyRequest data) {
        ApplyLoanData applyLoanData = new ApplyLoanData();

        applyLoanData.setRegisterFrom(RegisterFrom.JINSHAN)
        applyLoanData.setUserName(data.getUserName());
        applyLoanData.setPhone(data.getPhone());
        applyLoanData.setIdNo(data.getIdNo());
        applyLoanData.setChannelUserId(data.getChannelUserId());
        applyLoanData.setQq(data.getQq());
        applyLoanData.setEmail(data.getEmail());
        applyLoanData.setIncomeEnum(data.getIncomeEnum());
        applyLoanData.setIncomeRangeEnum(data.getIncomeRangeEnum());
        applyLoanData.setOccupationEnum(data.getOccupationEnum());
        applyLoanData.setEducationEnum(data.getEducationEnum());
        applyLoanData.setHasCar(data.getHasCar());
        applyLoanData.setHasSocialSecurity(data.getHasSocialSecurity());
        applyLoanData.setHasHouse(data.getHasHouse());
        applyLoanData.setHasCreditCard(data.getHasCreditCard());
        applyLoanData.setMarryStatus(data.getMarryStatus());
        applyLoanData.setContacts(data.getContacts());
        applyLoanData.setAddressLocation(data.getAddressLocation());
        applyLoanData.setAddrDetail(data.getAddrDetail());
        applyLoanData.setSingleAllAddress(data.getSingleAllAddress());
        applyLoanData.setDistrictCode(data.getDistrictCode());
        applyLoanData.setChannelOrderNo(data.getChannelOrderNo());
        applyLoanData.setChannelPaymentNo(data.getChannelPaymentNo());
        applyLoanData.setLoanAmount(data.getLoanAmount());
        applyLoanData.setLoanTerm(data.getLoanTerm());
        applyLoanData.setTermType(data.getTermType());
        applyLoanData.setPurposeEnum(data.getPurposeEnum());
        applyLoanData.setOrderExtData(data.getOrderExtData());
        applyLoanData.setRiskInfo(data.getRiskInfo());
    }


}
