package ${utilPackage};
import cn.quantgroup.loanflow.infrastructure.code.ApplicationServiceCode;
import lombok.Data;

import java.io.Serializable;


public class ${prefix}ResultUtils {

    public static ResultDTO success(String msg, Object data) {
        return new ResultDTO(msg, data);
    }

    public static ResultDTO success(Object data) {
        return new ResultDTO(data);
    }

    public static ResultDTO success() {
        return new ResultDTO();
    }

    public static ResultDTO fail(String code, String msg, Object data) {
        return new ResultDTO(code, msg, data);
    }

    public static ResultDTO fail(String code, String msg) {
        return new ResultDTO(code, msg, null);
    }

    public static ResultDTO fail(ApplicationServiceCode code) {
        return new ResultDTO(code.getCode(), code.getMsg(), null);
    }
    @Data
    public static class ResultDTO implements Serializable {

        private String code;

        private String message;

        private Object data;

        public ResultDTO() {
            this.code = "100000";
            this.message = "成功";
        }

        public ResultDTO(Object data) {
            this.data = data;
            this.code = "100000";
            this.message = "成功";
        }

        public ResultDTO(String msg) {
            this.code = "100000";
            this.message = msg;
        }

        public ResultDTO(String message, Object data) {
            this.code = "100000";
            this.message = message;
            this.data = data;
        }

        public ResultDTO(String code, String message, Object data) {
            this.code = code;
            this.message = message;
            this.data = data;
        }

        public boolean checkSuccess() {
            return "100000".equals(code);
        }
    }

}
