package cn.quantgroup.codegenerator.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;

/**
 * freemarker tool
 *
 * @author xuxueli 2018-05-02 19:56:00
 */
@Component
public class FreemarkerTool {

    @Autowired
    private Configuration configuration;

    /**
     * process Template Into String
     *
     * @param template
     * @param model
     * @return
     * @throws IOException
     * @throws TemplateException
     */
    public String processTemplateIntoString(Template template, Object model)
            throws IOException, TemplateException {


        StringWriter result = new StringWriter();
        template.process(model, result);
        return result.toString();
    }

    /**
     * process String
     *
     * @param templateName
     * @param params
     * @return
     * @throws IOException
     * @throws TemplateException
     */
    public String processString(String templateName, Map<String, Object> params)
            throws IOException, TemplateException {

        Template template = configuration.getTemplate(templateName);
        String htmlText = processTemplateIntoString(template, params);
        return htmlText;
    }


    @PostConstruct
    public void init(){
        processFile();
    }

    public void processFile(){
        String modelPath = System.getProperty("user.dir") + "\\src\\main\\resources\\templates\\code-generator\\model";
        String servicePath = System.getProperty("user.dir") + "\\src\\main\\resources\\templates\\code-generator\\service";
        String callbackPath = System.getProperty("user.dir") + "\\src\\main\\resources\\templates\\code-generator\\callback";
        String eventHandlerPath = System.getProperty("user.dir") + "\\src\\main\\resources\\templates\\code-generator\\eventhandler";
        String enumsPath = System.getProperty("user.dir") + "\\src\\main\\resources\\templates\\code-generator\\enums";
        String utilPath = System.getProperty("user.dir") + "\\src\\main\\resources\\templates\\code-generator\\util";


        try {
            Map<String,String> root = XmlParseUtil.parseXml();

            createJavaFile(root,modelPath,"model");
            createJavaFile(root,servicePath,"service");
            createJavaFile(root,callbackPath,"callback");
            createJavaFile(root,eventHandlerPath,"eventhandler");
            createJavaFile(root,enumsPath,"enums");
            createJavaFile(root,utilPath,"util");

        } catch (Exception e) {
            e.printStackTrace();
        }



    }

    private void createJavaFile(Map<String, String> root, String filePath,String target) throws Exception{


        File file = new File(filePath);

        if(!file.exists() || !file.isDirectory()){
            return;
        }

        File[] files = file.listFiles();
        for (File childFile : files) {
            String name = childFile.getName();
            Template template = configuration.getTemplate("code-generator/"+target+"/"+name);
            String path = root.get(target+"Path");
            File directory = new File(path);
            if(!directory.exists()){
                directory.mkdirs();
            }
            File javaFile = new File(path, root.get("prefix")+name.replace(".ftl",".java"));

            if(!javaFile.exists()) javaFile.createNewFile();
            FileWriter fw = new FileWriter(javaFile);
            template.process(root, fw);
            fw.close();
        }



    }


}
