package ${modelPackage};

import cn.quantgroup.loanflow.repay.model.representation.QueryNormalRepayRepresentation;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import cn.quantgroup.loanflow.repay.model.RepaymentPlanItem;
import ${enumsPackage}.${prefix}RepayTypeEnum;
import ${enumsPackage}.${prefix}RepayStatusEnum;
import ${callbackPackage}.${prefix}ContractInfoNotice;
import ${callbackPackage}.${prefix}InoutPlanNotice;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
* 查询还款结果出参
*
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
@Data
public class ${prefix}QueryRepayResult {

    private ${prefix}RepayStatusEnum repayStatus;
    private BigDecimal repayAmount;
    /**
    * 实际还款时间(金额实际到账的时间,精确到时分秒) 格式如：yyyy-MM-dd HH:mm:ss 成功的时候必填
    */
    private String actualTime;

    private String failMsg;
    private String failCode;
    private List<${prefix}ContractInfoNotice> contractList;
    private ${prefix}RepayTypeEnum repayType;



    public static ${prefix}QueryRepayResult getSuccessResult(String channelLoanNo, QueryNormalRepayRepresentation repayResult, List<RepaymentPlanItem> repaymentPlans) {
        String loanId = repayResult.getLoanId();
        String repaymentReceivedAt = repayResult.getRepaymentReceivedAt();

        ${prefix}QueryRepayResult callback = new ${prefix}QueryRepayResult();
        callback.setRepayStatus(${prefix}RepayStatusEnum.getStatusByRepayStatus(repayResult.getRepayStatus()));
        callback.setRepayType(${prefix}RepayTypeEnum.ACTIVE);
        if (StringUtils.isNotBlank(repayResult.getActualRepayment())) {
            callback.setRepayAmount(new BigDecimal(repayResult.getActualRepayment()));
        }
        if (${prefix}RepayStatusEnum.FAIL == callback.getRepayStatus()) {
            callback.setFailMsg(repayResult.getFailMsg());
            callback.setFailCode("0001");
        } else {
            callback.setActualTime(repaymentReceivedAt);
        }
        List<${prefix}ContractInfoNotice> contractInfoNotices = new ArrayList<>();
        ${prefix}ContractInfoNotice notice = new ${prefix}ContractInfoNotice();
        notice.setChannelLoanNo(channelLoanNo);
        notice.setLoanNo(loanId);
        List<${prefix}InoutPlanNotice> inoutPlanNotices = new ArrayList<>();
        repaymentPlans.forEach(i -> {
            ${prefix}InoutPlanNotice planNotice = new ${prefix}InoutPlanNotice();
            planNotice.setLeaseTime(i.getPeriodNo());
            planNotice.setReceivedCorpus(i.getActPrincipal());
            planNotice.setReceivedInterest(i.getActInterest());
            planNotice.setReceivedFine(i.getActOverdueInterest());
            planNotice.setReceivedInterestRate(BigDecimal.ZERO);
            planNotice.setReceivedTotalAmount(i.getRepayAmount());
            planNotice.setExtraFee(i.getActServiceFee());
            if (i.getActServiceFee().compareTo(BigDecimal.ZERO) != 0) {
                planNotice.setExtraInfo("担保费");
            }
            inoutPlanNotices.add(planNotice);
        });
        notice.setInoutPlanList(inoutPlanNotices);
        contractInfoNotices.add(notice);
        callback.setContractList(contractInfoNotices);
        return callback;
    }
}