package ${servicePackage};

import ${modelPackage}.${prefix}CreditApplyRequest;
import ${modelPackage}.${prefix}QueryCreditApplyResult;
import ${modelPackage}.${prefix}CreditApplyResult;
import ${modelPackage}.${prefix}QueryCreditApplyRequest;
import ${modelPackage}.${prefix}UserAccessRequest;
import ${modelPackage}.${prefix}UserAccessResult;
import ${modelPackage}.${prefix}QuerySupportBankcardsRequest;
import ${modelPackage}.${prefix}QuerySupportBankcardsResult;
import ${modelPackage}.${prefix}QueryLoanTrialRequest;
import ${modelPackage}.${prefix}QueryLoanTrialResult;
import ${modelPackage}.${prefix}BindBankCardSmsRequest;
import ${modelPackage}.${prefix}BindBankCardSmsResult;
import ${modelPackage}.${prefix}VerifyBindSmsRequest;
import ${modelPackage}.${prefix}VerifyBindSmsResult;
import ${modelPackage}.${prefix}ApplyLoanRequest;
import ${modelPackage}.${prefix}ApplyLoanResult;

import ${modelPackage}.${prefix}QueryLoanRequest;
import ${modelPackage}.${prefix}QueryLoanResult;
import ${modelPackage}.${prefix}RepayByPlanRequest;
import ${modelPackage}.${prefix}RepayByPlanResult;
import ${modelPackage}.${prefix}QueryRepayRequest;
import ${modelPackage}.${prefix}QueryRepayResult;
import cn.quantgroup.loanflow.application.model.ApplyLoanData;
import cn.quantgroup.loanflow.infrastructure.result.ServiceResult;


/** ${prefix} 渠道service
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
public interface ${prefix}Service {


    /**
    * 预审
    *
    * @param userAccessRequest
    * @return
    */
    ServiceResult<${prefix}UserAccessResult> userAccess(${prefix}UserAccessRequest userAccessRequest);

    /**
    * 提交授信
    *
    * @param request
    * @return
    */
    ServiceResult<${prefix}CreditApplyResult> creditApply(${prefix}CreditApplyRequest request);



    /**
    * 授信申请结果主动查询
    *
    * @param request
    * @return
    */
    ServiceResult<${prefix}QueryCreditApplyResult> queryCreditApply(${prefix}QueryCreditApplyRequest request);


    /**
    * 查询支持的银行列表
    *
    * @param request
    * @return
    */
    ServiceResult<${prefix}QuerySupportBankcardsResult> querySupportBankcards(${prefix}QuerySupportBankcardsRequest request);

    /**
    * 借款试算
    *
    * @param request
    * @return
    */
    ServiceResult<${prefix}QueryLoanTrialResult> queryLoanTrial(${prefix}QueryLoanTrialRequest request);


    /**
    * 绑卡发验证码
    *
    * @param request
    * @return
    */
    ServiceResult<${prefix}BindBankCardSmsResult> bindBankCardSms(${prefix}BindBankCardSmsRequest request);

    /**
    * 验卡
    *
    * @param request
    * @return
    */
    ServiceResult<${prefix}VerifyBindSmsResult> verifyBindSms(${prefix}VerifyBindSmsRequest request);


    /**
    * 申请提现
    *
    * @param request
    * @return
    */
    ServiceResult<${prefix}ApplyLoanResult> applyWithdraw(${prefix}ApplyLoanRequest request);


    /**
    * 借款结果查询
    *
    * @param request
    * @return
    */
    ServiceResult<${prefix}QueryLoanResult> queryLoanResult(${prefix}QueryLoanRequest request);


    /**
    * 主动还款
    *
    * @param request
    * @return
    */
    ServiceResult<${prefix}RepayByPlanResult>  repayByPlan(${prefix}RepayByPlanRequest request);

    /**
    * 查询还款结果
    *
    * @param request
    * @return
    */
    ServiceResult<${prefix}QueryRepayResult> queryRepayResult(${prefix}QueryRepayRequest request);

}


