package ${modelPackage};

import cn.quantgroup.loanflow.repay.model.representation.QueryNormalRepayRepresentation;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import cn.quantgroup.loanflow.repay.model.RepaymentPlanItem;
import ${enumsPackage}.${prefix}RepayTypeEnum;
import ${enumsPackage}.${prefix}RepayStatusEnum;
import ${callbackPackage}.${prefix}ContractInfoNotice;
import ${callbackPackage}.${prefix}InoutPlanNotice;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
* 查询还款结果出参
*
* @author ${author}
* @date ${.now?string('yyyy-MM-dd HH:mm:ss')}
*/
@Data
public class ${prefix}QueryRepayResult {

    private ${prefix}RepayStatusEnum repayStatus;
    private BigDecimal repayAmount;
    /**
    * 实际还款时间(金额实际到账的时间,精确到时分秒) 格式如：yyyy-MM-dd HH:mm:ss 成功的时候必填
    */
    private String actualTime;

    private ${prefix}RepayTypeEnum repayType;



    public static ${prefix}QueryRepayResult getSuccessResult(String channelLoanNo, QueryNormalRepayRepresentation repayResult, List<RepaymentPlanItem> repaymentPlans) {
        String loanId = repayResult.getLoanId();
        String repaymentReceivedAt = repayResult.getRepaymentReceivedAt();

        ${prefix}QueryRepayResult result = new ${prefix}QueryRepayResult();
        result.setRepayStatus(${prefix}RepayStatusEnum.getStatusByRepayStatus(repayResult.getRepayStatus()));
        result.setRepayType(${prefix}RepayTypeEnum.ACTIVE);
        if (StringUtils.isNotBlank(repayResult.getActualRepayment())) {
            result.setRepayAmount(new BigDecimal(repayResult.getActualRepayment()));
        }
        if (${prefix}RepayStatusEnum.FAIL == result.getRepayStatus()) {
           //还款失败情况
        } else {
           //还款成功情况
           result.setActualTime(repaymentReceivedAt);
        }


        return result;
    }
}